/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.lang;

import com.depotnearby.exception.MethodNotSupportException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public final class LockableArrayList<T>
extends ArrayList<T>
implements Serializable {
    private Boolean locked = false;
    private static final long serialVersionUID = -6923091521207823919L;

    @Override
    public boolean add(T t) {
        this.throwMethodUnsupportedIfLocked();
        return super.add(t);
    }

    @Override
    public void add(int index, T element) {
        this.throwMethodUnsupportedIfLocked();
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.throwMethodUnsupportedIfLocked();
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.throwMethodUnsupportedIfLocked();
        return super.addAll(index, c);
    }

    @Override
    public T set(int index, T element) {
        this.throwMethodUnsupportedIfLocked();
        return super.set(index, element);
    }

    @Override
    public T remove(int index) {
        this.throwMethodUnsupportedIfLocked();
        return (T)super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.throwMethodUnsupportedIfLocked();
        return super.remove(o);
    }

    @Override
    public void clear() {
        this.throwMethodUnsupportedIfLocked();
        super.clear();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.throwMethodUnsupportedIfLocked();
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.throwMethodUnsupportedIfLocked();
        return super.removeAll(c);
    }

    public void lock() {
        this.locked = true;
    }

    private void throwMethodUnsupportedIfLocked() {
        if (this.locked.booleanValue()) {
            throw new MethodNotSupportException("This list is locked. not support add and set anymore.");
        }
    }
}

