/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.model;

import java.util.Objects;

public enum VersionCompareStrategy {
    ALL("\u6240\u6709", 0, new int[]{-1, 0, 1}),
    LESS_THAN("\u5c0f\u4e8e", 1, new int[]{-1}),
    LESS_OR_EQUAL("\u5c0f\u4e8e\u7b49\u4e8e", 2, new int[]{-1, 0}),
    EQUAL("\u7b49\u4e8e", 3, new int[]{0}),
    GREATER_OR_EQUAL("\u5927\u4e8e\u7b49\u4e8e", 4, new int[]{0, 1}),
    GREATER_THAN("\u5927\u4e8e", 5, new int[]{1}),
    REG_EXP("\u6b63\u5219\u8868\u8fbe\u5f0f", 6, new int[0]);

    private String description;
    private Integer value;
    private int[] valuesOfCompareResult;

    private VersionCompareStrategy(String description, Integer value, int[] valuesOfCompareResult) {
        this.description = description;
        this.value = value;
        this.valuesOfCompareResult = valuesOfCompareResult;
    }

    public static VersionCompareStrategy getVersionCompareStrategyByValue(Integer value) {
        for (VersionCompareStrategy versionCompareStrategy : VersionCompareStrategy.values()) {
            if (!Objects.equals(versionCompareStrategy.getValue(), value)) continue;
            return versionCompareStrategy;
        }
        throw new IllegalArgumentException("There were not have any element's value matched given value.");
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getValue() {
        return this.value;
    }

    public int[] getValuesOfCompareResult() {
        return this.valuesOfCompareResult;
    }
}

