/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.product;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public enum ProductStatus {
    OFF_SALE(0, "\u4e0b\u67b6"),
    WAIT_FOR_ADD_SALE_PRICE(5, "\u7b49\u5f85\u8c03\u4ef7"),
    WAIT_FOR_SALE(9, "\u672a\u4e0a\u67b6"),
    ON_SALE(10, "\u4e0a\u67b6"),
    NEW_PRODUCT(1, "\u65b0\u54c1"),
    CAN_PRE_SALE(8, "\u662f"),
    NOT_PRE_SALE(4, "\u5426");

    private final Integer value;
    private final String description;

    private ProductStatus(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static ProductStatus changeStatus(Integer value) {
        if (Objects.equals(value, ProductStatus.ON_SALE.value)) {
            return OFF_SALE;
        }
        return ON_SALE;
    }

    public static String getStatus(Integer value) {
        if (Objects.equals(value, ProductStatus.OFF_SALE.value)) {
            return OFF_SALE.getDescription();
        }
        return ON_SALE.getDescription();
    }

    public static List<String> getSelectStatus() {
        ArrayList list = Lists.newArrayList();
        list.add(ProductStatus.WAIT_FOR_SALE.description);
        list.add(ProductStatus.ON_SALE.description);
        list.add(ProductStatus.OFF_SALE.description);
        return list;
    }
}

