/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.ro;

import com.depotnearby.common.NameAndValueAndDescriptionAbleEnum;
import com.depotnearby.common.ro.RedisObjMap;
import com.depotnearby.common.ro.annotation.RedisIgnore;
import com.depotnearby.common.ro.annotation.RedisReadIgnore;
import com.depotnearby.common.ro.annotation.RedisWriteIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.codelogger.utils.JudgeUtils;
import org.codelogger.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRedisObj {
    private static Logger logger = LoggerFactory.getLogger(AbstractRedisObj.class);
    private static final ConcurrentHashMap<Class, List<Field>> supportedWriteAbleFieldsMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class, List<Field>> supportedReadAbleFieldsMap = new ConcurrentHashMap();

    public void fromMap(Map<byte[], byte[]> map) {
        RedisObjMap objMap = new RedisObjMap(map);
        List<Field> declaredFields = this.getReadSupportedFields(this.getClass());
        for (Field declaredField : declaredFields) {
            String fieldName = declaredField.getName();
            Type genericType = declaredField.getGenericType();
            Object value = null;
            try {
                block25: {
                    if (genericType == Integer.class || genericType == Integer.TYPE) {
                        value = objMap.getInt(fieldName);
                    } else if (genericType == Long.class || genericType == Long.TYPE) {
                        value = objMap.getLong(fieldName);
                    } else if (genericType == String.class) {
                        value = objMap.getString(fieldName);
                    } else if (genericType == Boolean.class || genericType == Boolean.TYPE) {
                        value = objMap.getBoolean(fieldName);
                    } else if (genericType == Byte.class || genericType == Byte.TYPE) {
                        value = objMap.getByte(fieldName);
                    } else if (genericType == Short.class || genericType == Short.TYPE) {
                        value = objMap.getShort(fieldName);
                    } else if (genericType == BigDecimal.class) {
                        value = objMap.getBigDecimal(fieldName, 6);
                    } else if (genericType == Date.class || genericType == Timestamp.class) {
                        Long time = objMap.getLong(fieldName);
                        value = time == null ? null : new Timestamp(time);
                    } else if (((Class)genericType).isEnum()) {
                        String fieldValue = objMap.getString(fieldName);
                        if (StringUtils.isBlank((String)fieldValue)) {
                            value = null;
                        } else {
                            try {
                                value = Enum.valueOf((Class)genericType, fieldValue);
                            }
                            catch (Exception e) {
                                if (!NumberUtils.isNumber((String)fieldValue) || !NameAndValueAndDescriptionAbleEnum.class.isAssignableFrom((Class)genericType)) break block25;
                                for (Object enumConstant : ((Class)genericType).getEnumConstants()) {
                                    if (!Objects.equals(((NameAndValueAndDescriptionAbleEnum)enumConstant).getValue(), Integer.valueOf(fieldValue))) continue;
                                    value = enumConstant;
                                    break;
                                }
                            }
                        }
                    }
                }
                if (value == null) continue;
                declaredField.set(this, value);
            }
            catch (IllegalAccessException e) {
                logger.warn("Can not set {} to {}.{}", new Object[]{value, this.getClass().getName(), fieldName, e});
            }
        }
    }

    public Map<byte[], byte[]> toMap() {
        RedisObjMap map = new RedisObjMap();
        List<Field> declaredFields = this.getWriteSupportedFields(this.getClass());
        for (Field declaredField : declaredFields) {
            String fieldName = declaredField.getName();
            Type genericType = declaredField.getGenericType();
            try {
                if (genericType == Integer.class || genericType == Integer.TYPE) {
                    map.put(fieldName, (Integer)declaredField.get(this));
                    continue;
                }
                if (genericType == Long.class || genericType == Long.TYPE) {
                    map.put(fieldName, (Long)declaredField.get(this));
                    continue;
                }
                if (genericType == String.class) {
                    String value = (String)declaredField.get(this);
                    map.put(fieldName, value);
                    continue;
                }
                if (genericType == Boolean.class || genericType == Boolean.TYPE) {
                    map.put(fieldName, (Boolean)declaredField.get(this));
                    continue;
                }
                if (genericType == Byte.class || genericType == Byte.TYPE) {
                    map.put(fieldName, (Byte)declaredField.get(this));
                    continue;
                }
                if (genericType == Short.class || genericType == Short.TYPE) {
                    map.put(fieldName, (Short)declaredField.get(this));
                    continue;
                }
                if (genericType == BigDecimal.class) {
                    map.put(fieldName, (BigDecimal)declaredField.get(this), 6);
                    continue;
                }
                if (genericType == Date.class || genericType == Timestamp.class) {
                    Date ts = (Date)declaredField.get(this);
                    map.put(fieldName, ts == null ? null : Long.valueOf(ts.getTime()));
                    continue;
                }
                if (!((Class)genericType).isEnum()) continue;
                Enum em = (Enum)declaredField.get(this);
                map.put(fieldName, em == null ? null : em.name());
            }
            catch (IllegalAccessException e) {
                logger.warn("Can not get value of {}.{}", new Object[]{this.getClass().getName(), fieldName, e});
            }
        }
        return map.getSerialMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Field> getReadSupportedFields(Class roClass) {
        List<Field> supportedFields = supportedReadAbleFieldsMap.get(roClass);
        if (supportedFields != null) return supportedFields;
        Class<AbstractRedisObj> clazz = AbstractRedisObj.class;
        synchronized (AbstractRedisObj.class) {
            Field[] declaredFields;
            supportedFields = new ArrayList<Field>();
            for (Field declaredField : declaredFields = this.getClass().getDeclaredFields()) {
                if (Modifier.isFinal(declaredField.getModifiers()) || !JudgeUtils.allIsNull((Object)declaredField.getAnnotation(RedisIgnore.class), (Object[])new Object[]{declaredField.getAnnotation(RedisReadIgnore.class)})) continue;
                declaredField.setAccessible(true);
                Type genericType = declaredField.getGenericType();
                if (!this.isSupportDataType(genericType).booleanValue()) continue;
                supportedFields.add(declaredField);
            }
            supportedReadAbleFieldsMap.put(this.getClass(), supportedFields);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return supportedFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Field> getWriteSupportedFields(Class roClass) {
        List<Field> supportedFields = supportedWriteAbleFieldsMap.get(roClass);
        if (supportedFields != null) return supportedFields;
        Class<AbstractRedisObj> clazz = AbstractRedisObj.class;
        synchronized (AbstractRedisObj.class) {
            Field[] declaredFields;
            supportedFields = new ArrayList<Field>();
            for (Field declaredField : declaredFields = this.getClass().getDeclaredFields()) {
                if (Modifier.isFinal(declaredField.getModifiers()) || !JudgeUtils.allIsNull((Object)declaredField.getAnnotation(RedisIgnore.class), (Object[])new Object[]{declaredField.getAnnotation(RedisWriteIgnore.class)})) continue;
                declaredField.setAccessible(true);
                Type genericType = declaredField.getGenericType();
                if (!this.isSupportDataType(genericType).booleanValue()) continue;
                supportedFields.add(declaredField);
            }
            supportedWriteAbleFieldsMap.put(this.getClass(), supportedFields);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return supportedFields;
        }
    }

    private Boolean isSupportDataType(Type genericType) {
        if (genericType == Integer.class || genericType == Integer.TYPE) {
            return true;
        }
        if (genericType == Long.class || genericType == Long.TYPE) {
            return true;
        }
        if (genericType == String.class) {
            return true;
        }
        if (genericType == Boolean.class || genericType == Boolean.TYPE) {
            return true;
        }
        if (genericType == Byte.class || genericType == Byte.TYPE) {
            return true;
        }
        if (genericType == Short.class || genericType == Short.TYPE) {
            return true;
        }
        if (genericType == BigDecimal.class) {
            return true;
        }
        if (genericType == Date.class || genericType == Timestamp.class) {
            return true;
        }
        if (((Class)genericType).isEnum()) {
            return true;
        }
        return false;
    }
}

