/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.ro.bean;

import com.depotnearby.common.NameAndValueAndDescriptionAbleEnum;
import com.depotnearby.common.ro.RedisObjMap;
import com.depotnearby.common.ro.annotation.DataField;
import com.depotnearby.common.ro.annotation.RedisIgnore;
import com.depotnearby.common.ro.annotation.RedisReadIgnore;
import com.depotnearby.common.ro.annotation.RedisWriteIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.codelogger.utils.JudgeUtils;
import org.codelogger.utils.MapUtils;
import org.codelogger.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoConverter {
    private static Logger logger = LoggerFactory.getLogger(RoConverter.class);
    private static final ConcurrentHashMap<Class, List<Field>> supportedWriteAbleFieldsMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class, List<Field>> supportedReadAbleFieldsMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Field, String> fieldToRedisHashMemberKey = new ConcurrentHashMap();

    public static <T> T fromMap(Map<byte[], byte[]> map, Class<T> roClass) {
        T data;
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        try {
            data = roClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        RedisObjMap objMap = new RedisObjMap(map);
        List<Field> declaredFields = RoConverter.getReadSupportedFields(roClass);
        for (Field declaredField : declaredFields) {
            String fieldName = RoConverter.getFiledHashMemberKey(declaredField);
            Class<?> declaredFieldType = declaredField.getType();
            Object value = null;
            try {
                block28: {
                    if (declaredFieldType == Integer.class || declaredFieldType == Integer.TYPE) {
                        value = objMap.getInt(fieldName);
                    } else if (declaredFieldType == Long.class || declaredFieldType == Long.TYPE) {
                        value = objMap.getLong(fieldName);
                    } else if (declaredFieldType == String.class) {
                        value = objMap.getString(fieldName);
                    } else if (declaredFieldType == Boolean.class || declaredFieldType == Boolean.TYPE) {
                        value = objMap.getBoolean(fieldName);
                    } else if (declaredFieldType == Byte.class || declaredFieldType == Byte.TYPE) {
                        value = objMap.getByte(fieldName);
                    } else if (declaredFieldType == Short.class || declaredFieldType == Short.TYPE) {
                        value = objMap.getShort(fieldName);
                    } else if (declaredFieldType == BigDecimal.class) {
                        value = objMap.getBigDecimal(fieldName, 6);
                    } else if (declaredFieldType == Date.class || declaredFieldType == Timestamp.class) {
                        Long time = objMap.getLong(fieldName);
                        value = time == null ? null : new Timestamp(time);
                    } else if (declaredFieldType.isEnum()) {
                        String fieldValue = objMap.getString(fieldName);
                        if (StringUtils.isBlank((String)fieldValue)) {
                            value = null;
                        } else {
                            try {
                                value = Enum.valueOf(declaredFieldType, fieldValue);
                            }
                            catch (Exception e) {
                                if (!NumberUtils.isNumber((String)fieldValue) || !NameAndValueAndDescriptionAbleEnum.class.isAssignableFrom(declaredFieldType)) break block28;
                                for (Object enumConstant : declaredFieldType.getEnumConstants()) {
                                    if (!Objects.equals(((NameAndValueAndDescriptionAbleEnum)enumConstant).getValue(), Integer.valueOf(fieldValue))) continue;
                                    value = enumConstant;
                                    break;
                                }
                            }
                        }
                    }
                }
                if (value == null) continue;
                declaredField.set(data, value);
            }
            catch (IllegalAccessException e) {
                logger.warn("Can not set {} to {}.{}", new Object[]{value, roClass.getName(), fieldName, e});
            }
        }
        return data;
    }

    public static Map<byte[], byte[]> toMap(Object roData) {
        RedisObjMap map = new RedisObjMap();
        if (roData == null) {
            return map.getSerialMap();
        }
        Class<?> roClass = roData.getClass();
        List<Field> declaredFields = RoConverter.getWriteSupportedFields(roClass);
        for (Field declaredField : declaredFields) {
            String fieldName = RoConverter.getFiledHashMemberKey(declaredField);
            Class<?> declaredFieldType = declaredField.getType();
            try {
                if (declaredFieldType == Integer.class || declaredFieldType == Integer.TYPE) {
                    map.put(fieldName, (Integer)declaredField.get(roData));
                    continue;
                }
                if (declaredFieldType == Long.class || declaredFieldType == Long.TYPE) {
                    map.put(fieldName, (Long)declaredField.get(roData));
                    continue;
                }
                if (declaredFieldType == String.class) {
                    String value = (String)declaredField.get(roData);
                    map.put(fieldName, value);
                    continue;
                }
                if (declaredFieldType == Boolean.class || declaredFieldType == Boolean.TYPE) {
                    map.put(fieldName, (Boolean)declaredField.get(roData));
                    continue;
                }
                if (declaredFieldType == Byte.class || declaredFieldType == Byte.TYPE) {
                    map.put(fieldName, (Byte)declaredField.get(roData));
                    continue;
                }
                if (declaredFieldType == Short.class || declaredFieldType == Short.TYPE) {
                    map.put(fieldName, (Short)declaredField.get(roData));
                    continue;
                }
                if (declaredFieldType == BigDecimal.class) {
                    map.put(fieldName, (BigDecimal)declaredField.get(roData), 6);
                    continue;
                }
                if (declaredFieldType == Date.class || declaredFieldType == Timestamp.class) {
                    Date ts = (Date)declaredField.get(roData);
                    map.put(fieldName, ts == null ? null : Long.valueOf(ts.getTime()));
                    continue;
                }
                if (!declaredFieldType.isEnum()) continue;
                Enum em = (Enum)declaredField.get(roData);
                map.put(fieldName, em == null ? null : em.name());
            }
            catch (IllegalAccessException e) {
                logger.warn("Can not get value of {}.{}", new Object[]{roData.getClass().getName(), fieldName, e});
            }
        }
        return map.getSerialMap();
    }

    private static String getFiledHashMemberKey(Field declaredField) {
        return fieldToRedisHashMemberKey.get(declaredField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Field> getReadSupportedFields(Class roClass) {
        List<Field> supportedFields = supportedReadAbleFieldsMap.get(roClass);
        if (supportedFields != null) return supportedFields;
        Class<RoConverter> clazz = RoConverter.class;
        synchronized (RoConverter.class) {
            Field[] declaredFields;
            supportedFields = new ArrayList<Field>();
            for (Field declaredField : declaredFields = roClass.getDeclaredFields()) {
                if (Modifier.isFinal(declaredField.getModifiers()) || !JudgeUtils.allIsNull((Object)declaredField.getAnnotation(RedisIgnore.class), (Object[])new Object[]{declaredField.getAnnotation(RedisReadIgnore.class)})) continue;
                declaredField.setAccessible(true);
                Class<?> genericType = declaredField.getType();
                if (!RoConverter.isSupportDataType(genericType).booleanValue()) continue;
                supportedFields.add(declaredField);
                String filedHashMemberKey = declaredField.getName();
                DataField dataField = declaredField.getAnnotation(DataField.class);
                if (dataField != null && StringUtils.isNotBlank((String)dataField.name())) {
                    filedHashMemberKey = dataField.name();
                }
                fieldToRedisHashMemberKey.put(declaredField, filedHashMemberKey);
            }
            supportedReadAbleFieldsMap.put(roClass, supportedFields);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return supportedFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Field> getWriteSupportedFields(Class roClass) {
        List<Field> supportedFields = supportedWriteAbleFieldsMap.get(roClass);
        if (supportedFields != null) return supportedFields;
        Class<RoConverter> clazz = RoConverter.class;
        synchronized (RoConverter.class) {
            Field[] declaredFields;
            supportedFields = supportedWriteAbleFieldsMap.get(roClass);
            if (supportedFields != null) return supportedFields;
            supportedFields = new ArrayList<Field>();
            for (Field declaredField : declaredFields = roClass.getDeclaredFields()) {
                if (Modifier.isFinal(declaredField.getModifiers()) || !JudgeUtils.allIsNull((Object)declaredField.getAnnotation(RedisIgnore.class), (Object[])new Object[]{declaredField.getAnnotation(RedisWriteIgnore.class)})) continue;
                declaredField.setAccessible(true);
                Class<?> genericType = declaredField.getType();
                if (!RoConverter.isSupportDataType(genericType).booleanValue()) continue;
                supportedFields.add(declaredField);
                String filedHashMemberKey = declaredField.getName();
                DataField dataField = declaredField.getAnnotation(DataField.class);
                if (dataField != null && StringUtils.isNotBlank((String)dataField.name())) {
                    filedHashMemberKey = dataField.name();
                }
                fieldToRedisHashMemberKey.put(declaredField, filedHashMemberKey);
            }
            supportedWriteAbleFieldsMap.put(roClass, supportedFields);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return supportedFields;
        }
    }

    private static Boolean isSupportDataType(Type genericType) {
        if (genericType == Integer.class || genericType == Integer.TYPE) {
            return true;
        }
        if (genericType == Long.class || genericType == Long.TYPE) {
            return true;
        }
        if (genericType == String.class) {
            return true;
        }
        if (genericType == Boolean.class || genericType == Boolean.TYPE) {
            return true;
        }
        if (genericType == Byte.class || genericType == Byte.TYPE) {
            return true;
        }
        if (genericType == Short.class || genericType == Short.TYPE) {
            return true;
        }
        if (genericType == BigDecimal.class) {
            return true;
        }
        if (genericType == Date.class || genericType == Timestamp.class) {
            return true;
        }
        if (((Class)genericType).isEnum()) {
            return true;
        }
        return false;
    }
}

