/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.ro.bean;

import com.depotnearby.common.ro.annotation.Ro;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoKeyGenerator {
    private static Logger logger = LoggerFactory.getLogger(RoKeyGenerator.class);
    public static final Map<Class, RoKeyStorage> roClassToKeyStorage = Maps.newConcurrentMap();

    public static String getHashKeyPrefix(Class<?> roClass) {
        RoKeyStorage roKeyStorage = RoKeyGenerator.getRoKeyStorage(roClass);
        return roKeyStorage.getHashKeyPrefix();
    }

    public static String getHashKey(Class<?> roClass, Serializable id) {
        return RoKeyGenerator.getHashKeyPrefix(roClass) + id.toString();
    }

    public static String getIdSortedSetKey(Class<?> roClass) {
        RoKeyStorage roKeyStorage = RoKeyGenerator.getRoKeyStorage(roClass);
        return roKeyStorage.getIdSortedSetKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RoKeyStorage getRoKeyStorage(Class<?> roClass) {
        RoKeyStorage roKeyStorage = roClassToKeyStorage.get(roClass);
        if (roKeyStorage != null) return roKeyStorage;
        Class<RoKeyGenerator> clazz = RoKeyGenerator.class;
        synchronized (RoKeyGenerator.class) {
            roKeyStorage = roClassToKeyStorage.get(roClass);
            if (roKeyStorage != null) return roKeyStorage;
            logger.debug("Generate ro keys for {}", roClass);
            Ro roAnnotation = roClass.getAnnotation(Ro.class);
            if (roAnnotation == null) {
                throw new IllegalArgumentException(String.format("%s is not declared Ro annotation.", roClass));
            }
            roKeyStorage = new RoKeyStorage();
            String hashKeyPrefix = roAnnotation.hashKeyPrefix().trim();
            String idSortSetKey = roAnnotation.idSortSetKey().trim();
            if (StringUtils.isBlank((CharSequence)hashKeyPrefix)) {
                throw new IllegalArgumentException(String.format("%s Ro annotation hashKeyPrefix can not be blank.", roClass));
            }
            if (StringUtils.isBlank((CharSequence)idSortSetKey)) {
                throw new IllegalArgumentException(String.format("%s Ro annotation idSortSetKey can not be blank.", roClass));
            }
            roKeyStorage.setHashKeyPrefix(hashKeyPrefix.endsWith(":") ? hashKeyPrefix : hashKeyPrefix + ":");
            roKeyStorage.setIdSortedSetKey(idSortSetKey.endsWith(":") ? StringUtils.substringBeforeLast((String)idSortSetKey, (String)":") : idSortSetKey);
            roClassToKeyStorage.put(roClass, roKeyStorage);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return roKeyStorage;
        }
    }

    private static class RoKeyStorage {
        private String hashKeyPrefix;
        private String idSortedSetKey;

        private RoKeyStorage() {
        }

        public String getHashKeyPrefix() {
            return this.hashKeyPrefix;
        }

        public void setHashKeyPrefix(String hashKeyPrefix) {
            this.hashKeyPrefix = hashKeyPrefix;
        }

        public String getIdSortedSetKey() {
            return this.idSortedSetKey;
        }

        public void setIdSortedSetKey(String idSortedSetKey) {
            this.idSortedSetKey = idSortedSetKey;
        }
    }
}

