/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.service.mq.impl;

import com.depotnearby.common.service.mq.impl.RabbitConnection;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class RabbitConnPooledObjectFactory
extends BasePooledObjectFactory<RabbitConnection> {
    private ConnectionFactory connectionFactory;

    public RabbitConnPooledObjectFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public RabbitConnection create() throws Exception {
        RabbitConnection conn = new RabbitConnection();
        Connection origalConn = this.connectionFactory.newConnection();
        conn.setConn(origalConn);
        conn.setChannel(origalConn.createChannel());
        return conn;
    }

    public PooledObject<RabbitConnection> wrap(RabbitConnection obj) {
        return new DefaultPooledObject((Object)obj);
    }

    public void destroyObject(PooledObject<RabbitConnection> p) throws Exception {
        RabbitConnection wrapConn = (RabbitConnection)p.getObject();
        if (wrapConn.getChannel() != null) {
            try {
                wrapConn.getChannel().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (wrapConn.getConn() != null) {
            try {
                wrapConn.getConn().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

