/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.shop;

import com.depotnearby.exception.CommonRuntimeException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.math.NumberUtils;

public enum AuditRejectReason {
    DETAIL_INVALID(0, "\u8be6\u60c5\u5ba1\u6838\u4e0d\u901a\u8fc7"),
    BUSINESS_LICENCE_PHOTO_NOT_CLEAR(1, "\u8425\u4e1a\u6267\u7167\u4e0d\u6e05\u6670"),
    SHOP_PHOTO_INVALID(2, "\u95e8\u5934\u7167\u7247\u4e0d\u7b26\u5408\u5ba1\u6838\u8981\u6c42"),
    BUSINESS_LICENCE_ID_EXIST(3, "\u8425\u4e1a\u6267\u7167\u7f16\u53f7\u5df2\u88ab\u6ce8\u518c"),
    BUSINESS_LICENCE_TYPE_INVALID(4, "\u4f01\u4e1a\u7c7b\u578b\u4e0d\u7b26\u5408"),
    BUSINESS_LICENCE_SCOP_INVALID(5, "\u8425\u4e1a\u6267\u7167\u7ecf\u8425\u8303\u56f4\u4e0e\u5b9e\u9645\u8303\u56f4\u4e0d\u7b26\u5408");

    private final Integer value;
    private final String description;

    private AuditRejectReason(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    public static AuditRejectReason valueOf(Integer value) {
        for (AuditRejectReason shopDetailAuditStatus : AuditRejectReason.values()) {
            if (!Objects.equals(shopDetailAuditStatus.getValue(), value)) continue;
            return shopDetailAuditStatus;
        }
        throw new CommonRuntimeException("Illegal ShopDetailAuditStatus");
    }

    public static List<String> parseRejectReasons(String[] values) {
        ArrayList rejectReasons = Lists.newArrayList();
        if (values != null) {
            for (String value : values) {
                if (!NumberUtils.isNumber((String)value)) continue;
                rejectReasons.add(AuditRejectReason.valueOf(Integer.valueOf(value)).getDescription());
            }
        }
        return rejectReasons;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }
}

