/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.util;

import com.alibaba.fastjson.JSONObject;
import com.depotnearby.common.util.GZIPRequestInterceptor;
import com.depotnearby.common.util.GZIPResponseInterceptor;
import java.io.File;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.codelogger.utils.exceptions.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    protected static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static PoolingHttpClientConnectionManager connectionManager;
    public static CloseableHttpClient httpclient;
    private static Logger log;
    public static final int MAX_TOTAL_CONNECTIONS = 800;
    public static final int WAIT_TIMEOUT = 60000;
    public static final int MAX_ROUTE_CONNECTIONS = 250;
    public static final int CONNECT_TIMEOUT = 5000;
    public static final int READ_TIMEOUT = 8000;
    public static final int BUFFER_SIZE = 4096;
    public static final int SO_TIMEOUT = 60000;
    public static final String CHARSET = "UTF-8";

    public static void printHeader(HttpResponse response) {
        Header[] headers = response.getAllHeaders();
        StringBuilder cookie = new StringBuilder();
        for (int ii = 0; ii < headers.length; ++ii) {
            System.out.println(headers[ii].getName() + ": " + headers[ii].getValue());
            if (!StringUtils.equalsIgnoreCase((CharSequence)headers[ii].getName(), (CharSequence)"Set-Cookie")) continue;
            cookie.append(headers[ii].getValue()).append(";");
        }
        System.out.println(cookie.toString());
    }

    public static String doPost(String url, JSONObject jsonObject) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                map.put((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        catch (Exception e) {
            log.error("do post error", (Throwable)e);
        }
        try {
            return HttpClientUtil.doPostByLoop(url, map, 3);
        }
        catch (Exception e) {
            throw new HttpException(String.format("\u83b7\u53d6\u8fd4\u56de\u503c\u5931\u8d25, URL: '%s' . \u5c1d\u8bd5 '%s' \u6b21", url, 3));
        }
    }

    public static String doPost(String url, Map<String, String> map, int retryTimes) {
        try {
            return HttpClientUtil.doPostByLoop(url, map, retryTimes);
        }
        catch (Exception e) {
            throw new HttpException(String.format("\u83b7\u53d6\u8fd4\u56de\u503c\u5931\u8d25, URL: '%s' . \u5c1d\u8bd5 '%s' \u6b21", url, 3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> map) {
        HttpClientContext context = HttpClientContext.create();
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, CHARSET));
            response = httpclient.execute((HttpUriRequest)httpPost, (HttpContext)context);
            HttpEntity entity = response.getEntity();
            context.getCookieStore().clear();
            String string = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            httpPost.abort();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (Exception e) {
                log.error("Post Exception: ", (Throwable)e);
            }
        }
        return null;
    }

    public static String doPost(String url, String content) throws Exception {
        log.info("API\uff0cPOST\u8fc7\u53bb\u7684\u6570\u636e\u662f\uff1a{}", (Object)content);
        HttpPost httpPost = new HttpPost(url);
        StringEntity postEntity = new StringEntity(content, CHARSET);
        httpPost.addHeader("Content-type", "application/json");
        httpPost.setEntity((HttpEntity)postEntity);
        log.debug("\u6267\u884c\u8bf7\u6c42 " + httpPost.getRequestLine());
        String result = null;
        try {
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            logger.debug(result);
        }
        catch (ConnectionPoolTimeoutException e) {
            log.error("Exception: \u8fde\u63a5\u6c60\u8d85\u65f6.");
            throw new Exception(e);
        }
        catch (ConnectTimeoutException e) {
            log.error("Exception: \u8fde\u63a5\u8d85\u65f6");
            throw new Exception(e);
        }
        catch (SocketTimeoutException e) {
            log.error("Exception: Socket\u8d85\u65f6.");
            throw new Exception(e);
        }
        catch (ConnectException e) {
            log.error("Exception: \u8fde\u63a5\u88ab\u62d2\u7edd.");
            throw new Exception(e);
        }
        catch (Exception e) {
            log.error("HTTP Exception");
            throw e;
        }
        finally {
            httpPost.abort();
        }
        return result;
    }

    public static String doPost(String url, String content, int retryTimes) throws Exception {
        try {
            return HttpClientUtil.doPostByLoop(url, content, retryTimes);
        }
        catch (Exception e) {
            throw new HttpException(String.format("\u83b7\u53d6\u8fd4\u56de\u503c\u5931\u8d25, URL: '%s' . \u5c1d\u8bd5 '%s' \u6b21", url, Math.max(retryTimes, 1)));
        }
    }

    private static String doPostByLoop(String url, String content, int retryTimes) throws Exception {
        try {
            return HttpClientUtil.doPost(url, content);
        }
        catch (Exception e) {
            if ((e instanceof NoHttpResponseException || e instanceof HttpException) && retryTimes > 1) {
                return HttpClientUtil.doPost(url, content, --retryTimes);
            }
            throw e;
        }
    }

    private static String doPostByLoop(String url, Map<String, String> map, int retryTimes) throws Exception {
        try {
            return HttpClientUtil.doPost(url, map);
        }
        catch (Exception e) {
            if (e instanceof HttpException && retryTimes > 1) {
                return HttpClientUtil.doPost(url, map, --retryTimes);
            }
            throw e;
        }
    }

    public static String doPost(String url, String content, File file, String mimeType, int retryTimes) throws Exception {
        String result = null;
        HttpPost httpPost = new HttpPost(url);
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)content);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addBinaryBody("file", file, ContentType.create((String)mimeType), file.getName());
            for (String key : jsonObject.keySet()) {
                builder.addTextBody(key, String.valueOf(jsonObject.get((Object)key)), ContentType.DEFAULT_BINARY);
            }
            httpPost.setEntity(builder.build());
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
        }
        catch (ConnectionPoolTimeoutException e) {
            log.error("Exception: \u8fde\u63a5\u6c60\u8d85\u65f6.");
            throw new Exception(e);
        }
        catch (ConnectTimeoutException e) {
            log.error("Exception: \u8fde\u63a5\u8d85\u65f6");
            throw new Exception(e);
        }
        catch (SocketTimeoutException e) {
            log.error("Exception: Socket\u8d85\u65f6.");
            throw new Exception(e);
        }
        catch (ConnectException e) {
            log.error("Exception: \u8fde\u63a5\u88ab\u62d2\u7edd.");
            throw new Exception(e);
        }
        catch (Exception e) {
            log.error("HTTP Exception");
            if ((e instanceof NoHttpResponseException || e instanceof HttpException) && retryTimes > 1) {
                String string = HttpClientUtil.doPost(url, content, file, mimeType, --retryTimes);
                return string;
            }
            throw e;
        }
        finally {
            httpPost.abort();
        }
        return result;
    }

    static {
        httpclient = null;
        log = LoggerFactory.getLogger(HttpClientUtil.class);
        SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true).setSoTimeout(60000).setTcpNoDelay(false).setSoReuseAddress(true).setSoKeepAlive(true).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(4096).build();
        connectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build());
        connectionManager.setDefaultSocketConfig(socketConfig);
        connectionManager.setDefaultConnectionConfig(connectionConfig);
        connectionManager.setMaxTotal(800);
        connectionManager.setDefaultMaxPerRoute(250);
        httpclient = HttpClients.custom().addInterceptorFirst((HttpRequestInterceptor)new GZIPRequestInterceptor()).addInterceptorFirst((HttpResponseInterceptor)new GZIPResponseInterceptor()).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }
}

