/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.util;

import com.depotnearby.util.ZkProperties;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.codelogger.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.util.Hashing;

public final class RedisUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RedisUtil.class);
    private static ShardedJedisPool JEDIS_POOL;
    private Boolean configurationByZookeeper = false;
    private static final Charset DEFAULT_CHARSET;

    public static byte[] currentTs() {
        return RedisUtil.toByteArray(System.currentTimeMillis());
    }

    public static byte[] toByteArray(Serializable value) {
        return value == null ? new byte[]{} : value.toString().getBytes();
    }

    public static byte[] toByteArray(Boolean value) {
        return value == null ? new byte[]{} : (value != false ? "1" : "0").getBytes();
    }

    public static byte[] toByteArray(Byte value) {
        return value == null ? new byte[]{} : Byte.toString(value).getBytes();
    }

    public static byte[] toByteArray(Short value) {
        return value == null ? new byte[]{} : Short.toString(value).getBytes();
    }

    public static byte[] toByteArray(Integer value) {
        return value == null ? new byte[]{} : Integer.toString(value).getBytes();
    }

    public static byte[] toByteArray(Long value) {
        return value == null ? new byte[]{} : Long.toString(value).getBytes();
    }

    public static byte[] toByteArray(java.util.Date value) {
        if (value == null) {
            return null;
        }
        return Long.toString(value.getTime()).getBytes();
    }

    public static byte[] toByteArray(String value) {
        if (value == null) {
            return new byte[0];
        }
        return value.getBytes(DEFAULT_CHARSET);
    }

    public static byte[] toByteArray6(BigDecimal value) {
        return value == null ? new byte[]{} : RedisUtil.toByteArray(value.movePointRight(6).intValue());
    }

    public static BigDecimal byteArrayToBigDecimal6(byte[] b) {
        int intValue = RedisUtil.byteArrayToInt(b);
        return new BigDecimal(intValue).movePointLeft(6);
    }

    public static byte[][] toByteArray(int[] value) {
        byte[][] result = new byte[value.length][];
        for (int i = 0; i < value.length; ++i) {
            result[i] = RedisUtil.toByteArray(value[i]);
        }
        return result;
    }

    public static byte[][] toByteArray(List<Integer> list) {
        byte[][] result = new byte[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = RedisUtil.toByteArray(list.get(i));
        }
        return result;
    }

    public static byte[][] toByteArray(long[] value) {
        byte[][] result = new byte[value.length][];
        for (int i = 0; i < value.length; ++i) {
            result[i] = RedisUtil.toByteArray(value[i]);
        }
        return result;
    }

    public static Integer byteArrayToInt(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : Integer.valueOf(Integer.parseInt(new String(b)));
    }

    public static Long byteArrayToLong(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : Long.valueOf(Long.parseLong(new String(b)));
    }

    public static Short byteArrayToShort(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : Short.valueOf(Short.parseShort(new String(b)));
    }

    public static Byte byteArrayToByte(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : Byte.valueOf(Byte.parseByte(new String(b)));
    }

    public static Boolean byteArrayToBoolean(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : Boolean.valueOf("1".equals(new String(b)));
    }

    public static String byteArrayToStr(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : new String(b, DEFAULT_CHARSET);
    }

    public static byte[] toBitByteArray(long value) {
        byte[] byteNum = new byte[8];
        for (int ix = 0; ix < 8; ++ix) {
            int offset = 64 - (ix + 1) * 8;
            byteNum[ix] = (byte)(value >> offset & 0xFFL);
        }
        return byteNum;
    }

    public static byte[] toBitByteArray(int value) {
        byte[] byteNum = new byte[4];
        for (int ix = 0; ix < 4; ++ix) {
            int offset = 32 - (ix + 1) * 8;
            byteNum[ix] = (byte)(value >> offset & 0xFF);
        }
        return byteNum;
    }

    public static int bitByteArrayToInt(byte[] b) {
        int num = 0;
        for (int ix = 0; ix < b.length; ++ix) {
            num <<= 8;
            num |= b[ix] & 0xFF;
        }
        return num;
    }

    public static long bitByteArrayToLong(byte[] b) {
        long num = 0L;
        for (int ix = 0; ix < b.length; ++ix) {
            num <<= 8;
            num |= (long)(b[ix] & 0xFF);
        }
        return num;
    }

    public static Date byteArrayToDate(byte[] bytesValue) {
        long longValue = RedisUtil.byteArrayToLong(bytesValue);
        return new Date(longValue);
    }

    public static int[] bytesSetToIntArray(Set<byte[]> bytesSet) {
        if (bytesSet == null || bytesSet.isEmpty()) {
            return null;
        }
        int[] userIdArr = new int[bytesSet.size()];
        int count = 0;
        for (byte[] userIdBytes : bytesSet) {
            userIdArr[count] = RedisUtil.byteArrayToInt(userIdBytes);
            ++count;
        }
        return userIdArr;
    }

    public static List<Integer> bytesSetToIntList(Set<byte[]> bytesSet) {
        if (bytesSet == null || bytesSet.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList<Integer> userIdArr = new ArrayList<Integer>(bytesSet.size());
        for (byte[] userIdBytes : bytesSet) {
            userIdArr.add(RedisUtil.byteArrayToInt(userIdBytes));
        }
        return userIdArr;
    }

    public static Long[] bytesSetToLongArray(Set<byte[]> bytesSet) {
        if (CollectionUtils.isEmpty(bytesSet)) {
            return null;
        }
        Long[] idArr = new Long[bytesSet.size()];
        int count = 0;
        for (byte[] userIdBytes : bytesSet) {
            idArr[count] = RedisUtil.byteArrayToLong(userIdBytes);
            ++count;
        }
        return idArr;
    }

    public static List<Long> bytesSetToLongList(Set<byte[]> bytesSet) {
        if (CollectionUtils.isEmpty(bytesSet)) {
            return null;
        }
        ArrayList<Long> idList = new ArrayList<Long>(bytesSet.size());
        for (byte[] userIdBytes : bytesSet) {
            idList.add(RedisUtil.byteArrayToLong(userIdBytes));
        }
        return idList;
    }

    public static List<String> bytesSetToStringList(Set<byte[]> bytesSet) {
        if (CollectionUtils.isEmpty(bytesSet)) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>(bytesSet.size());
        for (byte[] bytes : bytesSet) {
            strings.add(RedisUtil.byteArrayToStr(bytes));
        }
        return strings;
    }

    public static List<String> bytesListToStringList(List<byte[]> bytesList) {
        if (CollectionUtils.isEmpty(bytesList)) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>(bytesList.size());
        for (byte[] bytes : bytesList) {
            strings.add(RedisUtil.byteArrayToStr(bytes));
        }
        return strings;
    }

    public static List<Long> strListToLongList(List<String> strings) {
        if (CollectionUtils.isEmpty(strings)) {
            return null;
        }
        ArrayList<Long> longs = new ArrayList<Long>(strings.size());
        for (String str : strings) {
            if (!StringUtils.isNotBlank((String)str) || Objects.equals(str, "null")) continue;
            longs.add(Long.valueOf(str));
        }
        return longs;
    }

    public static List<String> longListToStrList(List<Long> longs) {
        if (CollectionUtils.isEmpty(longs)) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>(longs.size());
        for (Long tmpLong : longs) {
            if (tmpLong == null) continue;
            strings.add(String.valueOf(tmpLong));
        }
        return strings;
    }

    public static String[] bytesSetToStringArray(Set<byte[]> bytesSet) {
        if (bytesSet == null || bytesSet.isEmpty()) {
            return null;
        }
        String[] userIdArr = new String[bytesSet.size()];
        int count = 0;
        for (byte[] userIdBytes : bytesSet) {
            userIdArr[count] = RedisUtil.byteArrayToStr(userIdBytes);
            ++count;
        }
        return userIdArr;
    }

    public static List<Long> stringSetToLongList(Set<String> stringSet) {
        if (CollectionUtils.isEmpty(stringSet)) {
            return null;
        }
        ArrayList<Long> idList = new ArrayList<Long>(stringSet.size());
        for (String s : stringSet) {
            idList.add(Long.valueOf(s));
        }
        return idList;
    }

    public static synchronized ShardedJedisPool getJedisPool() {
        return JEDIS_POOL;
    }

    public static synchronized ShardedJedisPool getJedisPool(String zookeeperUrl, Boolean configByZookeeper, String localConfigPath) {
        if (JEDIS_POOL == null) {
            PropertiesConfiguration config;
            LOG.debug("\u5f00\u59cb\u521d\u59cb\u5316redis\u6c60\u5bf9\u8c61");
            try {
                if (configByZookeeper.booleanValue() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)zookeeperUrl)) {
                    LOG.debug("zookeeper\u52a0\u8f7dredis\u914d\u7f6e\u6587\u4ef6");
                    ZkProperties zkProperties = new ZkProperties("/depotnearby/config/redis.properties");
                    config = new PropertiesConfiguration();
                    config.load((InputStream)new ByteArrayInputStream(zkProperties.getPropertiesBytes()));
                } else {
                    config = new PropertiesConfiguration(localConfigPath);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\u52a0\u8f7dredis\u914d\u7f6e\u51fa\u9519", e);
            }
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(config.getInt("redis.pool.maxTotal"));
            poolConfig.setMaxIdle(config.getInt("redis.pool.maxIdle"));
            LOG.debug("\u5f00\u59cb\u52a0\u8f7dredis\u4e3b\u673a\u5217\u8868");
            String ipKeyPrefix = "redis.ip";
            String portKeyPrefix = "redis.port";
            String nameKeyPrefix = "redis.name";
            String passwordKeyPrefix = "redis.password";
            ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
            Iterator keys = config.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!key.startsWith(ipKeyPrefix)) continue;
                String host = config.getString(key);
                String hostNo = key.substring(ipKeyPrefix.length());
                String name = config.getString(nameKeyPrefix + hostNo);
                String password = config.getString(passwordKeyPrefix + hostNo);
                int port = config.getInt(portKeyPrefix + hostNo);
                LOG.debug("redis\u4e3b\u673a, no: {}, host: {}, port: {}, name: {}", new Object[]{hostNo, host, port, name});
                JedisShardInfo jedisShardInfo = new JedisShardInfo(host, port, config.getInt("redis.pool.socketTimeout", 2000), name);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)password)) {
                    jedisShardInfo.setPassword(password);
                }
                shards.add(jedisShardInfo);
            }
            if (shards.isEmpty()) {
                throw new RuntimeException("\u8bf7\u6307\u5b9a\u81f3\u5c11\u4e00\u4e2aredis\u4e3b\u673a");
            }
            JEDIS_POOL = new ShardedJedisPool((GenericObjectPoolConfig)poolConfig, shards, (Hashing)new MyHashing());
        }
        return JEDIS_POOL;
    }

    public void setConfigurationByZookeeper(Boolean configurationByZookeeper) {
        this.configurationByZookeeper = configurationByZookeeper;
    }

    static {
        DEFAULT_CHARSET = Charset.forName("UTF-8");
    }

    public static class MyHashing
    implements Hashing {
        static final String keys = "global user shop colony timeline deal";

        public long hash(String key) {
            if (key.indexOf("SHARD-") == 0) {
                return 0L;
            }
            return keys.indexOf(org.apache.commons.lang3.StringUtils.substringBefore((String)key, (String)"*"));
        }

        public long hash(byte[] key) {
            return keys.indexOf(org.apache.commons.lang3.StringUtils.substringBefore((String)new String(key), (String)":"));
        }
    }
}

