/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.util;

import com.depotnearby.util.ZkProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisShardInfo;

public final class RedissonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RedissonUtil.class);
    private static RedissonClient REDISSON;

    public static RedissonClient getRedisson() {
        return REDISSON;
    }

    public static RedissonClient getRedisson(String zookeeperUrl, boolean configByZookeeper, String localConfigPath) throws IOException {
        PropertiesConfiguration config;
        if (REDISSON != null) {
            return REDISSON;
        }
        try {
            if (configByZookeeper && StringUtils.isNotBlank((CharSequence)zookeeperUrl)) {
                LOG.debug("zookeeper\u52a0\u8f7dredis\u914d\u7f6e\u6587\u4ef6");
                ZkProperties zkProperties = new ZkProperties("/depotnearby/config/redis.properties");
                config = new PropertiesConfiguration();
                config.load((InputStream)new ByteArrayInputStream(zkProperties.getPropertiesBytes()));
            } else {
                config = new PropertiesConfiguration(localConfigPath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u8f7dredis\u914d\u7f6e\u51fa\u9519", e);
        }
        LOG.debug("\u5f00\u59cb\u52a0\u8f7dredis\u4e3b\u673a\u5217\u8868");
        String ipKeyPrefix = "redis.ip";
        String portKeyPrefix = "redis.port";
        String nameKeyPrefix = "redis.name";
        String passwordKeyPrefix = "redis.password";
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        Iterator keys = config.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith(ipKeyPrefix)) continue;
            String host = config.getString(key);
            String hostNo = key.substring(ipKeyPrefix.length());
            String name = config.getString(nameKeyPrefix + hostNo);
            String password = config.getString(passwordKeyPrefix + hostNo);
            int port = config.getInt(portKeyPrefix + hostNo);
            LOG.debug("redis\u4e3b\u673a, no: {}, host: {}, port: {}, name: {}", new Object[]{hostNo, host, port, name});
            JedisShardInfo jedisShardInfo = new JedisShardInfo(host, port, config.getInt("redis.pool.socketTimeout", 2000), name);
            if (StringUtils.isNotBlank((CharSequence)password)) {
                jedisShardInfo.setPassword(password);
            }
            shards.add(jedisShardInfo);
        }
        if (shards.isEmpty()) {
            throw new RuntimeException("\u8bf7\u6307\u5b9a\u81f3\u5c11\u4e00\u4e2aredis\u4e3b\u673a");
        }
        Config redissonConfig = new Config();
        JedisShardInfo jedisShardInfo = (JedisShardInfo)shards.get(0);
        ((SingleServerConfig)redissonConfig.useSingleServer().setAddress(jedisShardInfo.getHost() + ":" + jedisShardInfo.getPort()).setPassword(jedisShardInfo.getPassword())).setConnectionPoolSize(1000);
        REDISSON = Redisson.create((Config)redissonConfig);
        return REDISSON;
    }
}

