/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.ro.mq;

import com.depotnearby.common.ro.annotation.Ro;
import java.io.Serializable;
import org.codelogger.utils.MD5Utils;
import org.codelogger.utils.StringUtils;
import org.codelogger.utils.ValueUtils;

@Ro(hashKeyPrefix="mqMsg", idSortSetKey="mqMsg:all")
public class MQMessageRo
implements Serializable {
    private static final long serialVersionUID = 6144266964919405289L;
    private String queueName;
    private String dataClass;
    private String data;
    private Long latestProcessTime;
    private Long retryPeriod;
    private Integer failedCount;
    private Integer maxFailedCount;
    private String mailTo;

    public MQMessageRo() {
    }

    public MQMessageRo(String queueName, String dataClass, String data, Long latestProcessTime, Long retryPeriod, Integer failedCount, Integer maxFailedCount, String mailTo) {
        if (StringUtils.isBlank((String)queueName) || StringUtils.isBlank((String)data) || StringUtils.isBlank((String)dataClass)) {
            throw new IllegalArgumentException(String.format("queueName[%s], data[%s] and dataClass[%s] can not be blank.", queueName, data, dataClass));
        }
        this.queueName = queueName;
        this.dataClass = dataClass;
        this.data = data;
        this.latestProcessTime = latestProcessTime == null ? System.currentTimeMillis() : latestProcessTime;
        this.retryPeriod = ValueUtils.getValue((Long)retryPeriod);
        this.failedCount = ValueUtils.getValue((Integer)failedCount);
        this.maxFailedCount = ValueUtils.getValue((Integer)maxFailedCount);
        this.mailTo = mailTo;
    }

    public String getId() {
        return MD5Utils.getMD5((String)(this.queueName + this.dataClass + this.data)) + "_" + this.failedCount;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getDataClass() {
        return this.dataClass;
    }

    public void setDataClass(String dataClass) {
        this.dataClass = dataClass;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Long getLatestProcessTime() {
        return this.latestProcessTime;
    }

    public void setLatestProcessTime(Long latestProcessTime) {
        this.latestProcessTime = latestProcessTime;
    }

    public Long getRetryPeriod() {
        return this.retryPeriod;
    }

    public void setRetryPeriod(Long retryPeriod) {
        this.retryPeriod = retryPeriod;
    }

    public Integer getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(Integer failedCount) {
        this.failedCount = failedCount;
    }

    public Integer getMaxFailedCount() {
        return this.maxFailedCount;
    }

    public void setMaxFailedCount(Integer maxFailedCount) {
        this.maxFailedCount = maxFailedCount;
    }

    public String getMailTo() {
        return this.mailTo;
    }

    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }
}

