/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.search;

import com.depotnearby.common.model.geo.IArea;
import com.depotnearby.common.model.geo.IBusiness;
import com.depotnearby.util.PinyinUtil;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AreaIndexDataAdapter {
    private Integer id;
    private int level;
    private String name;
    private double lon;
    private double lat;
    private long boost = 1L;
    private int weight = 0;
    private String code;
    private double[] box;

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public long getBoost() {
        return this.boost;
    }

    public void setBoost(long boost) {
        this.boost = boost;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public double[] getBox() {
        return this.box;
    }

    public String getContent() {
        StringBuilder sb = new StringBuilder();
        Map<String, String> pinyinMap = PinyinUtil.getPingYinAndChinese(this.name);
        if (pinyinMap != null && !pinyinMap.isEmpty()) {
            for (String pinyin : pinyinMap.keySet()) {
                if (pinyin.length() > 50) {
                    pinyin = pinyin.substring(0, 50);
                }
                sb.append(pinyin).append(" ");
            }
        }
        if ((pinyinMap = PinyinUtil.getFirstLetter(this.name)) != null && !pinyinMap.isEmpty()) {
            for (String pinyin : pinyinMap.keySet()) {
                if (pinyin.length() > 50) {
                    pinyin = pinyin.substring(0, 50);
                }
                sb.append(pinyin).append(" ");
            }
        }
        if (StringUtils.isNotBlank((String)this.code)) {
            sb.append(this.code).append(" ");
        }
        if (StringUtils.isNotBlank((String)this.name)) {
            sb.append(this.name).append(" ");
        }
        return sb.toString();
    }

    public boolean isAddToIndex() {
        return true;
    }

    public static AreaIndexDataAdapter copyFrom(IArea area) {
        AreaIndexDataAdapter adapter = new AreaIndexDataAdapter();
        adapter.id = area.getId();
        adapter.level = area.getLevel();
        adapter.lat = area.getLat() == null ? 0.0 : area.getLat().doubleValue();
        adapter.lon = area.getLon() == null ? 0.0 : area.getLon().doubleValue();
        adapter.name = area.getName();
        adapter.code = area.getCode();
        adapter.weight = area.getWeight() == null ? 0 : area.getWeight();
        long l = adapter.boost = area.getWeight() == null ? 1L : (long)area.getWeight().intValue();
        if (adapter.getLevel() == 5) {
            IBusiness po = (IBusiness)area;
            adapter.box = po.getOutBox();
        }
        return adapter;
    }
}

