/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.service;

import com.depotnearby.common.service.mq.impl.RabbitConnPooledObjectFactory;
import com.depotnearby.common.service.mq.impl.RabbitConnection;
import com.depotnearby.dao.redis.IMQRedisDao;
import com.depotnearby.exception.CommonException;
import com.depotnearby.service.MQService;
import com.depotnearby.util.ZkProperties;
import com.rabbitmq.client.ConnectionFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MQServiceFactory.class);
    private static MQService SERVICE_INSTANCE;

    public static MQService getService() {
        return SERVICE_INSTANCE;
    }

    public static MQService getService(String localConfigPath) {
        return MQServiceFactory.getService(null, false, localConfigPath, null);
    }

    public static MQService getService(String zookeeperUrl, Boolean configByZookeeper, String localConfigPath) {
        return MQServiceFactory.getService(zookeeperUrl, configByZookeeper, localConfigPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MQService getService(String zookeeperUrl, Boolean configByZookeeper, String localConfigPath, IMQRedisDao mqRedisDao) {
        if (SERVICE_INSTANCE != null) return SERVICE_INSTANCE;
        Class<MQServiceFactory> clazz = MQServiceFactory.class;
        synchronized (MQServiceFactory.class) {
            if (SERVICE_INSTANCE != null) return SERVICE_INSTANCE;
            try {
                SERVICE_INSTANCE = MQServiceFactory.initMqService(zookeeperUrl, configByZookeeper, localConfigPath, mqRedisDao);
            }
            catch (Exception e) {
                throw new RuntimeException("\u521d\u59cb\u5316\u6d88\u606f\u670d\u52a1\u5931\u8d25", e);
            }
            return SERVICE_INSTANCE;
        }
    }

    private static MQService initMqService(String zookeeperUrl, Boolean configByZookeeper, String localConfigPath, IMQRedisDao mqRedisDao) throws ConfigurationException, CommonException {
        PropertiesConfiguration config;
        try {
            if (configByZookeeper.booleanValue() && StringUtils.isNotBlank((CharSequence)zookeeperUrl)) {
                LOG.debug("zookeeper\u52a0\u8f7dmq\u914d\u7f6e\u6587\u4ef6");
                ZkProperties zkProperties = new ZkProperties("/messageQueue.properties");
                config = new PropertiesConfiguration();
                config.load((InputStream)new ByteArrayInputStream(zkProperties.getPropertiesBytes()));
            } else {
                config = new PropertiesConfiguration(localConfigPath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("messageQueue", e);
        }
        String mqHost = config.getString("mq.host");
        int mqPort = config.getInt("mq.port");
        String[] queueNames = config.getStringArray("mq.queues");
        String[] topicNames = config.getStringArray("mq.topics");
        LOG.debug("\u5f00\u59cb\u521d\u59cb\u5316MQ\u6d88\u606f\u670d\u52a1, host:{}, port:{},queues:{},topics{}", new Object[]{mqHost, mqPort, queueNames, topicNames});
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setAutomaticRecoveryEnabled(true);
        connectionFactory.setHost(mqHost);
        connectionFactory.setPort(mqPort);
        connectionFactory.setUsername(config.getString("mq.username"));
        connectionFactory.setPassword(config.getString("mq.password"));
        RabbitConnPooledObjectFactory factory = new RabbitConnPooledObjectFactory(connectionFactory);
        GenericObjectPool objectPoolPool = new GenericObjectPool((PooledObjectFactory)factory);
        objectPoolPool = PoolUtils.synchronizedPool((ObjectPool)objectPoolPool);
        return new MQService((ObjectPool<RabbitConnection>)objectPoolPool, queueNames, topicNames, mqRedisDao);
    }
}

