/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public final class DateTool {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long TWOHOUR = 0x6DDD00L;
    public static final long DAY = 86400000L;
    public static final long DAY3 = 259200000L;
    public static final long DAY7 = 604800000L;
    public static final long DAY15 = 1296000000L;
    public static final long DAY30 = 2592000000L;
    public static final SimpleDateFormat SQL92_STANDARD_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    public static final SimpleDateFormat SQL92_STANDARD_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat SQL92_STANDARD_YEAR_MONTH = new SimpleDateFormat("yyyy-MM");

    private DateTool() {
    }

    public static String durationFormat(long duration) {
        if (duration >= 86400000L) {
            return duration / 86400000L + "\u5929";
        }
        if (duration >= 3600000L) {
            return duration / 3600000L + "\u5c0f\u65f6";
        }
        if (duration >= 60000L) {
            return duration / 60000L + "\u5206\u949f";
        }
        return duration / 1000L + "\u79d2";
    }

    public static java.sql.Date today() {
        return new java.sql.Date(System.currentTimeMillis());
    }

    public static Timestamp nowTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static int betweenDays(Date from, Date to) {
        long duration = to.getTime() - from.getTime();
        return (int)(duration / 86400000L + (long)(duration % 86400000L == 0L ? 0 : 1));
    }

    public static java.sql.Date weekAgo() {
        Calendar c = Calendar.getInstance();
        c.add(5, -7);
        return new java.sql.Date(c.getTimeInMillis());
    }

    public static long beforeDays(int days) {
        days = days < 0 ? days : -days;
        Calendar c = Calendar.getInstance();
        c.add(5, days);
        return c.getTimeInMillis();
    }

    public static long afterDays(int days) {
        Calendar c = Calendar.getInstance();
        c.add(5, days);
        return c.getTimeInMillis();
    }

    public static int getWeek1to7(long timeMillis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMillis);
        int week = c.get(7);
        if (week == 1) {
            return 7;
        }
        return week - 1;
    }

    public static String getWeekName(int week) {
        switch (week) {
            case 1: {
                return "\u5468\u4e00";
            }
            case 2: {
                return "\u5468\u4e8c";
            }
            case 3: {
                return "\u5468\u4e09";
            }
            case 4: {
                return "\u5468\u56db";
            }
            case 5: {
                return "\u5468\u4e94";
            }
            case 6: {
                return "\u5468\u516d";
            }
            case 7: {
                return "\u5468\u65e5";
            }
        }
        return "";
    }

    public static int getTimeInMinute(long timeMillis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMillis);
        return c.get(11) * 60 + c.get(12);
    }

    public static int getTime(long ts, int calendarType) {
        Calendar calDate = Calendar.getInstance();
        calDate.setTime(new Date(ts));
        return calDate.get(calendarType);
    }

    public static String nowStr() {
        return new Timestamp(System.currentTimeMillis()).toString().substring(0, 19);
    }

    public static String formatTo24Hour(int minute) {
        if (minute <= 0) {
            return "00:00";
        }
        if (minute >= 1440) {
            return "24:00";
        }
        return DateTool.prefixDecade(minute / 60) + ":" + DateTool.prefixDecade(minute % 60);
    }

    private static String prefixDecade(int num) {
        return num >= 10 ? "" + num : "0" + num;
    }

    public static String getMinuteItBPay(Long limitTime) {
        Calendar calendar = Calendar.getInstance();
        Long nowTime = calendar.getTimeInMillis();
        Long betweenMinute = (limitTime - nowTime) / 1000L / 60L;
        return betweenMinute + "m";
    }

    public static String getNowDate() {
        return org.codelogger.utils.DateUtils.getDateFormat((Date)new Date(), (String)"yyyyMMdd");
    }

    public static String getNowFmtDatetime(String fmt) {
        return org.codelogger.utils.DateUtils.getDateFormat((Date)new Date(), (String)fmt);
    }

    public static Long getTime(String fmtDateStr) {
        return org.codelogger.utils.DateUtils.getDateFromString((String)fmtDateStr).getTime();
    }

    public static Timestamp newTimestamp(String fmtDateStr) {
        return new Timestamp(DateTool.getTime(fmtDateStr));
    }

    public static Timestamp getTimestamp(String dateStr) {
        if (StringUtils.isNotBlank((CharSequence)dateStr) && dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
            return DateTool.getTimestamp(dateStr, "yyyy-MM-dd");
        }
        return DateTool.getTimestamp(dateStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static Timestamp getTimestamp(String dateStr, String dateFmt) {
        Timestamp timestamp = null;
        SimpleDateFormat f = new SimpleDateFormat(dateFmt);
        try {
            timestamp = new Timestamp(f.parse(dateStr).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static boolean isToday(Long currentTime) {
        return StringUtils.equals((CharSequence)new java.sql.Date(System.currentTimeMillis()).toString(), (CharSequence)new java.sql.Date(currentTime).toString());
    }

    public static boolean isMonth(Long currentTime) {
        GregorianCalendar min = new GregorianCalendar();
        ((Calendar)min).add(5, -30);
        return currentTime >= min.getTimeInMillis();
    }

    public static long getTodayStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public static Long getTodayEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime().getTime();
    }

    public static Long getOneHourAgoTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - 1);
        return calendar.getTime().getTime();
    }

    public static String longToDateStr(long time, String fmtDateStr) {
        SimpleDateFormat s = new SimpleDateFormat(fmtDateStr);
        String dateStr = s.format(new Date(time));
        return dateStr;
    }

    public static String formatChars(long time) {
        return DateTool.longToDateStr(time, "yyyy-MM-dd HH:mm:ss");
    }

    public static int getAfterSeconds(Long futureTime) {
        if (futureTime == null) {
            return 0;
        }
        int durationSeconds = (int)((futureTime - System.currentTimeMillis()) / 1000L);
        return durationSeconds >= 0 ? durationSeconds : 0;
    }

    public static int hourToMinutes(String hourOfDay) {
        if (StringUtils.isBlank((CharSequence)hourOfDay)) {
            return 0;
        }
        int hour = Integer.valueOf(StringUtils.substringBefore((String)hourOfDay, (String)":"));
        int minute = Integer.valueOf(StringUtils.substringAfter((String)hourOfDay, (String)":"));
        return hour * 60 + minute;
    }

    public static JSONObject buildDayStartTimeAndEndTime(Date day) {
        JSONObject json = new JSONObject();
        json.put("DayStartTime", (Object)SQL92_STANDARD_DATETIME_FORMAT.format(DateUtils.truncate((Date)day, (int)5)));
        json.put("DayEndTime", (Object)SQL92_STANDARD_DATETIME_FORMAT.format(DateUtils.addMilliseconds((Date)DateUtils.ceiling((Date)day, (int)5), (int)-1)));
        return json;
    }

    public static JSONObject buildMonthStartDayAndEndDay(String monthDateString) throws ParseException {
        JSONObject json = new JSONObject();
        Calendar calendar = Calendar.getInstance();
        Date day = SQL92_STANDARD_DATE_FORMAT.parse(monthDateString);
        calendar.setTime(day);
        calendar.set(5, 1);
        String monthStartDay = SQL92_STANDARD_DATE_FORMAT.format(calendar.getTime());
        calendar.set(5, calendar.getActualMaximum(5));
        String monthEndDay = SQL92_STANDARD_DATE_FORMAT.format(calendar.getTime());
        json.put("CurrentMonthStartDay", (Object)monthStartDay);
        json.put("CurrentMonthEndDay", (Object)monthEndDay);
        return json;
    }

    public static String getMonthNameByYearMonth(String monthDateString) throws ParseException {
        Date day = SQL92_STANDARD_YEAR_MONTH.parse(monthDateString);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day);
        DateFormatSymbols dfs = new DateFormatSymbols(Locale.CHINA);
        return dfs.getMonths()[calendar.get(2)];
    }

    public static JSONObject buildPreviousMonthStartDayAndEndDay(String monthDayString) throws ParseException {
        JSONObject json = new JSONObject();
        Calendar calendar = Calendar.getInstance();
        Date day = SQL92_STANDARD_DATE_FORMAT.parse(monthDayString);
        calendar.setTime(day);
        calendar.add(2, -1);
        calendar.set(5, 1);
        String monthStartDay = SQL92_STANDARD_DATE_FORMAT.format(calendar.getTime());
        calendar.set(5, calendar.getActualMaximum(5));
        String monthEndDay = SQL92_STANDARD_DATE_FORMAT.format(calendar.getTime());
        System.out.println(monthStartDay);
        System.out.println(monthEndDay);
        json.put("PreviousMonthStartDay", (Object)monthStartDay);
        json.put("PreviousMonthEndDay", (Object)monthEndDay);
        return json;
    }

    public static Timestamp buildMonthEndDayTimestamp(String monthDayString) throws ParseException {
        Date day = SQL92_STANDARD_DATE_FORMAT.parse(monthDayString);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTime().getTime());
    }

    public static String buildAddDayLongTimestamp(Long time, Integer day, String fmt) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(time));
        calendar.add(5, day);
        return DateTool.longToDateStr(calendar.getTime().getTime(), fmt);
    }

    public static Timestamp afterDays(Date date, Integer days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return new Timestamp(calendar.getTimeInMillis());
    }
}

