/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.depotnearby.common.QiniuBucket;
import com.depotnearby.util.ConfigUtils;
import com.depotnearby.util.QiniuUtil;
import com.depotnearby.util.WaterMarkUtil;
import com.depotnearby.vo.config.QiniuBucketVo;
import com.google.common.collect.Lists;
import com.qingstor.sdk.chinayanghe.QsPutObjectRequest;
import com.qingstor.sdk.chinayanghe.QssObjectUtils;
import com.qingstor.sdk.model.OutputModel;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepotnearbyQiNiuUtils {
    public static String bucketsName;
    public static QiniuBucketVo product;
    public static QiniuBucketVo avatar;
    public static QiniuBucketVo audit;
    public static QiniuBucketVo source;
    private static List<QiniuBucketVo> buckets;
    private static final Logger logger;

    public static String getAvatarUrl(String fileName) {
        return QiniuUtil.getDownloadUrl((String)DepotnearbyQiNiuUtils.avatar.domain, (String)fileName);
    }

    public static String getProductUrl(String fileName) {
        return QiniuUtil.getDownloadUrl((String)DepotnearbyQiNiuUtils.product.domain, (String)fileName);
    }

    public static Boolean isProductItemExist(String fileName) {
        return QiniuUtil.isFileExist((String)DepotnearbyQiNiuUtils.product.name, (String)fileName);
    }

    public static String getAuditDownloadUrl(String fileName) {
        return QiniuUtil.getDownloadUrl((String)DepotnearbyQiNiuUtils.audit.domain, (String)fileName);
    }

    public static String uploadProductFile(InputStream inputStream, String fileName) {
        QiniuUtil.put((String)DepotnearbyQiNiuUtils.product.name, (InputStream)inputStream, (String)fileName, null);
        return QiniuUtil.getDownloadUrl((String)DepotnearbyQiNiuUtils.product.domain, (String)fileName);
    }

    public static String uploadSourceFile(InputStream inputStream, String fileName) {
        QiniuUtil.put((String)DepotnearbyQiNiuUtils.source.name, (InputStream)inputStream, (String)fileName, null);
        return QiniuUtil.getDownloadUrl((String)DepotnearbyQiNiuUtils.source.domain, (String)fileName);
    }

    public static String uploadProductFile(InputStream inputStream, String fileName, String tab, String waterMarkRealFileName) {
        if ("products".equals(tab)) {
            inputStream = WaterMarkUtil.imageAddWaterMark(inputStream, waterMarkRealFileName);
        }
        QsPutObjectRequest req = new QsPutObjectRequest(bucketsName, fileName, inputStream, "image/jpg");
        OutputModel result = QssObjectUtils.putObject((QsPutObjectRequest)req);
        String path = null;
        if (result != null && result.getStatueCode() == 201) {
            path = QssObjectUtils.getQssResourceUrL((String)bucketsName, (String)fileName);
        }
        return path;
    }

    public static String getAvatarDownloadUrl(String fileName) {
        return QiniuUtil.getDownloadUrl((String)DepotnearbyQiNiuUtils.avatar.domain, (String)fileName);
    }

    public static String uploadAvatarFile(InputStream inputStream, String fileName) {
        QiniuUtil.put((String)DepotnearbyQiNiuUtils.avatar.name, (InputStream)inputStream, (String)fileName, null);
        return QiniuUtil.getDownloadUrl((String)DepotnearbyQiNiuUtils.avatar.domain, (String)fileName);
    }

    public static String getAvatarUploadToken() {
        return QiniuUtil.getUploadTokenByBucketName((String)DepotnearbyQiNiuUtils.avatar.name);
    }

    public static String uploadAuditFile(InputStream inputStream, String fileName) {
        QiniuUtil.put((String)DepotnearbyQiNiuUtils.audit.name, (InputStream)inputStream, (String)fileName, null);
        return QiniuUtil.getDownloadUrl((String)DepotnearbyQiNiuUtils.audit.domain, (String)fileName);
    }

    public static String getAuditUploadToken() {
        return QiniuUtil.getUploadTokenByBucketName((String)DepotnearbyQiNiuUtils.audit.name);
    }

    public static List<QiniuBucketVo> getBuckets() {
        return buckets;
    }

    static {
        buckets = Lists.newArrayList();
        logger = LoggerFactory.getLogger(QiniuUtil.class);
        Properties properties = null;
        try {
            properties = ConfigUtils.loadFromFileOrZooKeeper((String)"/depotnearby/config/qiniu.properties", (String)"qiniu.properties");
        }
        catch (Exception e) {
            logger.info("\u6ca1\u6709\u53d1\u73b0qiniu\u914d\u7f6e\u6587\u4ef6.", (Throwable)e);
        }
        if (properties != null && !properties.isEmpty()) {
            logger.info("\u53d1\u73b0\u4e03\u725b\u914d\u7f6e\u6587\u4ef6:{}", (Object)properties);
            product = new QiniuBucketVo(QiniuBucket.PRODUCT.getType(), properties.getProperty(QiniuBucket.PRODUCT.getBucketNameKey()), properties.getProperty(QiniuBucket.PRODUCT.getDomainKey()));
            buckets.add(product);
            avatar = new QiniuBucketVo(QiniuBucket.AVATAR.getType(), properties.getProperty(QiniuBucket.AVATAR.getBucketNameKey()), properties.getProperty(QiniuBucket.AVATAR.getDomainKey()));
            buckets.add(avatar);
            source = new QiniuBucketVo(QiniuBucket.SOURCE.getType(), properties.getProperty(QiniuBucket.SOURCE.getBucketNameKey()), properties.getProperty(QiniuBucket.SOURCE.getDomainKey()));
            buckets.add(source);
            audit = new QiniuBucketVo(QiniuBucket.AUDIT.getType(), properties.getProperty(QiniuBucket.AUDIT.getBucketNameKey()), properties.getProperty(QiniuBucket.AUDIT.getDomainKey()));
            buckets.add(audit);
        } else {
            logger.warn("\u672a\u53d1\u73b0\u4e03\u725b\u914d\u7f6e\u6587\u4ef6");
        }
        try {
            properties = ConfigUtils.loadFromFileOrZooKeeper((String)"/depotnearby/config/qingstore.properties", (String)"qingstore.properties");
        }
        catch (Exception e) {
            logger.info("\u6ca1\u6709\u53d1\u73b0qingstore\u914d\u7f6e\u6587\u4ef6.", (Throwable)e);
        }
        if (properties != null && !properties.isEmpty()) {
            logger.info("\u53d1\u73b0\u9752\u4e91\u914d\u7f6e\u6587\u4ef6:{}", (Object)properties);
            bucketsName = properties.getProperty("buckets_name");
        }
    }
}

