/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinyinUtil {
    private static Logger logger = LoggerFactory.getLogger(PinyinUtil.class);
    public static HanyuPinyinOutputFormat pinyinOutputFormat = new HanyuPinyinOutputFormat();

    public static String prepareKeyword(String keyword) {
        if (keyword != null) {
            return keyword.replaceAll("[\\s \u3000]*", "");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getPingYin(String src) {
        if (src != null) {
            String keyword = PinyinUtil.prepareKeyword(src);
            char[] charArray = keyword.toCharArray();
            String[] pinyinArray = null;
            HashMap<String, String> tempCharMap = new HashMap<String, String>();
            HashMap<String, String> tempStrPinyinMap = new HashMap<String, String>();
            HashMap<String, String> resultPinyinMap = new HashMap<String, String>();
            String key_char2 = null;
            String key_str2 = null;
            try {
                for (int i = 0; i < charArray.length; ++i) {
                    tempCharMap = new HashMap();
                    if (Character.toString(charArray[i]).matches("[\\u4E00-\\u9FA5]+")) {
                        pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)charArray[i], (HanyuPinyinOutputFormat)pinyinOutputFormat);
                        if (pinyinArray != null) {
                            for (int j = 0; j < pinyinArray.length; ++j) {
                                tempCharMap.put(pinyinArray[j], Character.toString(charArray[i]));
                            }
                        }
                    } else {
                        tempCharMap.put(Character.toString(charArray[i]), Character.toString(charArray[i]));
                    }
                    Iterator it_str = null;
                    for (String key_char2 : tempCharMap.keySet()) {
                        if (i == 0) {
                            resultPinyinMap.put(key_char2, "");
                            continue;
                        }
                        for (String key_str2 : tempStrPinyinMap.keySet()) {
                            resultPinyinMap.remove(key_str2);
                            key_str2 = key_str2 + key_char2;
                            resultPinyinMap.put(key_str2, "");
                        }
                    }
                    tempStrPinyinMap.clear();
                    tempStrPinyinMap.putAll(resultPinyinMap);
                }
            }
            catch (Exception e) {
                logger.error("\u8f6c\u7801\u9519\u8bef", (Throwable)e);
            }
            finally {
                tempCharMap.clear();
                tempStrPinyinMap.clear();
            }
            return resultPinyinMap;
        }
        return null;
    }

    public static String getFullSpell(String chinese) {
        if (StringUtils.isBlank((CharSequence)chinese)) {
            return null;
        }
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    pybf.append(PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat)[0]);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString().replaceAll("u:", "v");
    }

    public static String getFirstSpell(String chinese) {
        if (StringUtils.isBlank((CharSequence)chinese)) {
            return null;
        }
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (temp == null) continue;
                    pybf.append(temp[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString().replaceAll("\\W", "").trim().replaceAll("u:", "v");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getFirstLetter(String src) {
        if (src != null) {
            String keyword = PinyinUtil.prepareKeyword(src);
            char[] charArray = keyword.toCharArray();
            String[] pinyinArray = null;
            HashMap<Character, String> tempCharMap = new HashMap<Character, String>();
            HashMap<String, String> tempStrPinyinMap = new HashMap<String, String>();
            HashMap<String, String> resultPinyinMap = new HashMap<String, String>();
            Character key_char2 = null;
            String key_str2 = null;
            try {
                for (int i = 0; i < charArray.length; ++i) {
                    tempCharMap = new HashMap();
                    if (Character.toString(charArray[i]).matches("[\\u4E00-\\u9FA5]+")) {
                        pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)charArray[i], (HanyuPinyinOutputFormat)pinyinOutputFormat);
                        if (pinyinArray != null) {
                            for (int j = 0; j < pinyinArray.length; ++j) {
                                tempCharMap.put(Character.valueOf(pinyinArray[j].charAt(0)), Character.toString(charArray[i]));
                            }
                        }
                    } else {
                        tempCharMap.put(Character.valueOf(charArray[i]), Character.toString(charArray[i]));
                    }
                    Iterator it_str = null;
                    for (Character key_char2 : tempCharMap.keySet()) {
                        if (i == 0) {
                            resultPinyinMap.put(Character.toString(key_char2.charValue()), "");
                            continue;
                        }
                        for (String key_str2 : tempStrPinyinMap.keySet()) {
                            resultPinyinMap.remove(key_str2);
                            key_str2 = key_str2 + key_char2;
                            resultPinyinMap.put(key_str2, "");
                        }
                    }
                    tempStrPinyinMap.clear();
                    tempStrPinyinMap.putAll(resultPinyinMap);
                }
            }
            catch (Exception e) {
                logger.error("\u8f6c\u7801\u9519\u8bef", (Throwable)e);
            }
            finally {
                tempCharMap.clear();
                tempStrPinyinMap.clear();
            }
            return resultPinyinMap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getPingYinAndChinese(String src) {
        if (src != null) {
            String keyword = PinyinUtil.prepareKeyword(src);
            char[] charArray = keyword.toCharArray();
            String[] pinyinArray = null;
            HashMap<String, String> tempCharMap = new HashMap<String, String>();
            HashMap<String, String> tempStrPinyinMap = new HashMap<String, String>();
            HashMap<String, String> resultPinyinMap = new HashMap<String, String>();
            String key_char2 = null;
            String key_str2 = null;
            try {
                for (int i = 0; i < charArray.length; ++i) {
                    tempCharMap = new HashMap();
                    if (Character.toString(charArray[i]).matches("[\\u4E00-\\u9FA5]+") && (pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)charArray[i], (HanyuPinyinOutputFormat)pinyinOutputFormat)) != null) {
                        for (int j = 0; j < pinyinArray.length; ++j) {
                            tempCharMap.put(pinyinArray[j], Character.toString(charArray[i]));
                        }
                    }
                    tempCharMap.put(Character.toString(charArray[i]), Character.toString(charArray[i]));
                    Iterator it_str = null;
                    for (String key_char2 : tempCharMap.keySet()) {
                        if (i == 0) {
                            resultPinyinMap.put(key_char2, "");
                            continue;
                        }
                        for (String key_str2 : tempStrPinyinMap.keySet()) {
                            resultPinyinMap.remove(key_str2);
                            key_str2 = key_str2 + key_char2;
                            resultPinyinMap.put(key_str2, "");
                        }
                    }
                    tempStrPinyinMap.clear();
                    tempStrPinyinMap.putAll(resultPinyinMap);
                }
            }
            catch (Exception e) {
                logger.error("\u8f6c\u7801\u9519\u8bef", (Throwable)e);
            }
            finally {
                tempCharMap.clear();
                tempStrPinyinMap.clear();
            }
            return resultPinyinMap;
        }
        return null;
    }

    public static void main(String[] args) {
        new PinyinUtil();
        Iterator<String> it = PinyinUtil.getFirstLetter("\u957f\u5b89").keySet().iterator();
        while (it.hasNext()) {
            System.out.println("" + it.next());
        }
    }

    static {
        pinyinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        pinyinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        pinyinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
    }
}

