/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.depotnearby.common.model.GlobalParams;
import com.depotnearby.common.model.InitGlobalParams;
import com.depotnearby.exception.CommonRuntimeException;
import com.depotnearby.vo.CommonReqVo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RestUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();
    private static final String POST_DATA_PARAM_NAME = "data";

    public static <T> T parseBizData(HttpServletRequest httpRequest, Class<T> clazz) throws CommonRuntimeException {
        String bizData = httpRequest.getParameter(POST_DATA_PARAM_NAME);
        LOG.debug("\u8bf7\u6c42\u53c2\u6570:\n{}", (Object)bizData);
        Object t = null;
        try {
            t = StringUtils.isNotBlank((CharSequence)bizData) ? OBJECT_MAPPER.readValue(bizData, clazz) : (Object)clazz.newInstance();
        }
        catch (Exception e) {
            LOG.error("\u89e3\u6790\u63a5\u53e3\u4e1a\u52a1\u53c2\u6570\u51fa\u9519", (Throwable)e);
            throw new CommonRuntimeException("\u89e3\u6790\u63a5\u53e3\u4e1a\u52a1\u53c2\u6570\u51fa\u9519", 903, e);
        }
        if (t instanceof InitGlobalParams) {
            GlobalParams globalParams = RestUtil.parseGlobalParams(httpRequest);
            ((InitGlobalParams)t).setGlobalParams(globalParams);
        }
        Class<?>[] groups = null;
        if (t instanceof CommonReqVo) {
            CommonReqVo crv = (CommonReqVo)t;
            crv.bindRequestParams(httpRequest);
            groups = crv.groupClazz();
        }
        RestUtil.validate(t, groups);
        return (T)t;
    }

    public static GlobalParams parseGlobalParams(HttpServletRequest httpRequest) {
        GlobalParams params = null;
        try {
            String lonStr;
            GlobalParams p = new GlobalParams();
            p.setApn(httpRequest.getParameter("apn"));
            p.setDeviceId(httpRequest.getParameter("deviceId"));
            String latStr = httpRequest.getParameter("lat");
            if (StringUtils.isNotEmpty((CharSequence)latStr)) {
                try {
                    p.setLat(new BigDecimal(latStr));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(lonStr = httpRequest.getParameter("lon")))) {
                try {
                    p.setLon(new BigDecimal(lonStr));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            p.setOs(httpRequest.getParameter("os"));
            p.setOsVersion(httpRequest.getParameter("osVersion"));
            p.setPartner(httpRequest.getParameter("partner"));
            p.setSign(httpRequest.getParameter("sign"));
            p.setSub(httpRequest.getParameter("sub"));
            p.setUserAgent(httpRequest.getParameter("userAgent"));
            String userIdStr = httpRequest.getParameter("userId");
            if (StringUtils.isNumeric((CharSequence)userIdStr)) {
                p.setUserId(Long.valueOf(userIdStr));
            }
            p.setVer(httpRequest.getParameter("ver"));
            p.setMac(httpRequest.getParameter("mac"));
            p.setImsi(httpRequest.getParameter("imsi"));
            p.setImei(httpRequest.getParameter("imei"));
            p.setRouterMac(httpRequest.getParameter("routerMac"));
            p.setStation(httpRequest.getParameter("station"));
            params = p;
        }
        catch (Exception e) {
            LOG.error("\u89e3\u6790\u5168\u5c40\u53c2\u6570\u51fa\u9519", (Throwable)e);
        }
        return params;
    }

    private static void validate(Object obj, Class<?> ... groups) throws CommonRuntimeException {
        Set constraintViolations = null;
        constraintViolations = groups == null || groups.length == 0 ? VALIDATOR.validate(obj, new Class[0]) : VALIDATOR.validate(obj, (Class[])groups);
        if (constraintViolations != null && !constraintViolations.isEmpty()) {
            StringBuilder errorInfo = new StringBuilder();
            for (ConstraintViolation cv : constraintViolations) {
                errorInfo.append(cv.getPropertyPath()).append(", ").append(cv.getMessage()).append("; ");
            }
            throw new CommonRuntimeException("\u4e1a\u52a1\u53c2\u6570\u7ea6\u675f\u51fa\u9519:" + errorInfo, 903);
        }
    }
}

