/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.codelogger.utils.StringUtils;

public final class StringTool {
    public static final String MOBILE_REG = "^((14[0-9])|(13[0-9])|(17[0-9])|(15[^4,\\D])|(18[0-9]))\\d{8}$";
    public static final String TEL_REG = "(^(\\d{3,4}-)?\\d{7,8})$";
    private static DecimalFormat df1 = new DecimalFormat("#.##");
    private static DecimalFormat ONE_DECEMAL_PLACES_FORMAT = new DecimalFormat("#.#");

    private StringTool() {
    }

    public static String[] stringToArray(String str, String delim) {
        StringTokenizer st = new StringTokenizer(str, delim);
        int count = st.countTokens();
        String[] strArr = new String[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            strArr[i++] = st.nextToken();
        }
        return strArr;
    }

    public static String arrayToString(String[] array, String delim) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delim + array[i]);
                continue;
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static List<Integer> strToIntArray(String source) {
        String[] arr;
        ArrayList<Integer> result = null;
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{source}) && (arr = source.split(",")) != null && arr.length > 0) {
            result = new ArrayList<Integer>();
            for (String s : arr) {
                result.add(Integer.valueOf(s));
            }
        }
        return result;
    }

    public static long ipToLong(String ip) {
        long result = 0L;
        String[] ip_feild = ip.split("\\.");
        try {
            for (int i = 0; i < ip_feild.length; ++i) {
                result += Long.parseLong(ip_feild[i]) << 8 * (3 - i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String encodedByMD5(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(password.getBytes());
            return StringTool.byte2string(md.digest());
        }
        catch (Exception e) {
            return password;
        }
    }

    public static String encodedBySHA1(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(source.getBytes());
            return StringTool.byte2string(md.digest());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String base64Encode(String s) {
        try {
            return Base64.encodeBase64String((byte[])s.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String base64Encode(byte[] b) {
        return Base64.encodeBase64String((byte[])b);
    }

    public static String base64Decode(String s) {
        try {
            return new String(Base64.decodeBase64((String)s), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] base64DecodeB(String s) {
        return Base64.decodeBase64((String)s);
    }

    public static String encodedUrl(String str) {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (Exception e) {
            return str;
        }
    }

    public static String byte2string(byte[] b) {
        StringBuffer hs = new StringBuffer(100);
        for (int n = 0; n < b.length; ++n) {
            hs.append(StringTool.byte2fex(b[n]));
        }
        return hs.toString();
    }

    public static String byte2fex(byte ib) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        String s = new String(ob);
        return s;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static boolean isMobileValid(String mobile) {
        return org.apache.commons.lang3.StringUtils.trimToEmpty((String)mobile).matches(MOBILE_REG);
    }

    public static boolean isTelValid(String tel) {
        return org.apache.commons.lang3.StringUtils.trimToEmpty((String)tel).matches(TEL_REG);
    }

    public static String contactWayFormat(String mobile, String tels) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tels) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)mobile)) {
            return "";
        }
        String result = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)mobile) ? "" : mobile + ",";
        String string = tels = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tels) ? "" : tels;
        if (org.apache.commons.lang3.StringUtils.contains((CharSequence)tels, (CharSequence)mobile)) {
            tels = org.apache.commons.lang3.StringUtils.remove((String)tels, (String)mobile);
        }
        result = result + tels;
        if ((result = result.replaceAll("(,)+", ",")).endsWith(",")) {
            result = org.apache.commons.lang3.StringUtils.substring((String)result, (int)0, (int)(result.length() - 1));
        }
        return result;
    }

    public static String userIdToInvitationCode(int userId) {
        return org.apache.commons.lang3.StringUtils.reverse((String)Integer.toString(userId, 36)).toUpperCase();
    }

    public static Integer invitationCodeToUserId(String invitationCode) {
        try {
            return Integer.valueOf(org.apache.commons.lang3.StringUtils.reverse((String)StringUtils.trimAllWhitespace((String)invitationCode)), 36);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatPriceToYun(double value) {
        return df1.format(value / 100.0);
    }

    public static String formatPriceToYuanWithFen(int value) {
        int fen = value % 100;
        return value / 100 + "." + (fen < 10 ? "0" + fen : Integer.valueOf(fen));
    }

    public static Integer formatPriceToFen(String value) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        Double doubleValue = null;
        try {
            doubleValue = Double.valueOf(value) * 100.0;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return doubleValue == null ? null : Integer.valueOf(doubleValue.intValue());
    }

    public static int getByteLength(String s) {
        if (s == null) {
            return 0;
        }
        s = s.replaceAll("[^\\x00-\\xff]", "**");
        int length = s.length();
        return length;
    }

    public static void blankFill(String[] chars, String fill) {
        if (chars == null || chars.length == 0) {
            return;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)chars[i])) continue;
            chars[i] = fill;
        }
    }

    public static String filterInvalidChars(String str, String regex) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        String content = new String(str);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        String result = m.replaceAll("");
        return result;
    }

    public static String mist(String conent) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)conent)) {
            return "*";
        }
        String mistedStr = String.valueOf(conent.charAt(0));
        mistedStr = mistedStr + (conent.length() > 3 ? "**" + conent.charAt(conent.length() - 1) : (conent.length() > 2 ? "*" + conent.charAt(conent.length() - 1) : "*"));
        return mistedStr;
    }

    public static String getDiscountChars(Integer currentPrice, Integer originalPrice) {
        return StringTool.discount(currentPrice, originalPrice) + "\u6298";
    }

    public static double discount(Integer currentPrice, Integer originalPrice) {
        if (originalPrice == null || originalPrice == 0 || currentPrice == null || currentPrice == 0) {
            return 0.0;
        }
        return Double.valueOf(ONE_DECEMAL_PLACES_FORMAT.format(currentPrice.doubleValue() / originalPrice.doubleValue() * 10.0));
    }

    public static void main(String[] args) throws Exception {
        System.out.println(StringTool.getDiscountChars(266, 1000));
    }

    public static String listToStr(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String str : strings) {
            sb.append(str).append(",");
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }
}

