/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.depotnearby.util.UnicodeReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

public class UnicodeEntityUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(HttpEntity entity, Charset defaultCharset) throws IOException, ParseException {
        Args.notNull((Object)entity, (String)"Entity");
        InputStream instream = entity.getContent();
        if (instream == null) {
            return null;
        }
        try {
            int l;
            Charset charset;
            int i;
            block11: {
                Args.check((entity.getContentLength() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"HTTP entity too large to be buffered in memory");
                i = (int)entity.getContentLength();
                if (i < 0) {
                    i = 4096;
                }
                charset = null;
                try {
                    ContentType contentType = ContentType.get((HttpEntity)entity);
                    if (contentType != null) {
                        charset = contentType.getCharset();
                    }
                }
                catch (UnsupportedCharsetException ex) {
                    if (defaultCharset != null) break block11;
                    throw new UnsupportedEncodingException(ex.getMessage());
                }
            }
            if (charset == null) {
                charset = defaultCharset;
            }
            if (charset == null) {
                charset = HTTP.DEF_CONTENT_CHARSET;
            }
            UnicodeReader reader = new UnicodeReader(instream, null);
            CharArrayBuffer buffer = new CharArrayBuffer(i);
            char[] tmp = new char[1024];
            while ((l = reader.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            instream.close();
        }
    }

    public static String toString(HttpEntity entity, String defaultCharset) throws IOException, ParseException {
        return UnicodeEntityUtils.toString(entity, defaultCharset != null ? Charset.forName(defaultCharset) : null);
    }

    public static String toString(HttpEntity entity) throws IOException, ParseException {
        return UnicodeEntityUtils.toString(entity, (Charset)null);
    }
}

