/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.depotnearby.common.QiniuBucket;
import com.depotnearby.common.account.AccountImage;
import com.depotnearby.common.util.JsonUtil;
import com.depotnearby.util.ConfigUtils;
import com.depotnearby.util.DepotnearbyQiNiuUtils;
import com.depotnearby.util.QiniuUtil;
import com.depotnearby.vo.config.QiniuBucketVo;
import com.depotnearby.vo.zsgf.ZsgfAuditImgVo;
import com.google.common.collect.Lists;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.ImageIcon;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterMarkUtil {
    public static final String waterMarkFileName = "/watermark.png";
    private static List<QiniuBucketVo> buckets = Lists.newArrayList();
    private static Logger logger = LoggerFactory.getLogger(WaterMarkUtil.class);

    public static List<ZsgfAuditImgVo> getImageUris(String photos, Long id) {
        try {
            if (StringUtils.isEmpty((CharSequence)photos)) {
                logger.debug("\u7533\u8bf7[{}]\u7684\u6388\u4fe1\u56fe\u7247\u4e3a\u7a7a.", (Object)id);
                return null;
            }
            if (StringUtils.isBlank((CharSequence)photos)) {
                logger.debug("\u7533\u8bf7[{}]\u7684\u6388\u4fe1\u56fe\u7247\u4e3a\u7a7a.", (Object)id);
                return null;
            }
            logger.trace("Ximu apply data photos:{} for shop:{}", (Object)photos, (Object)id);
            ArrayList images = Lists.newArrayList();
            HashMap photoMap = (HashMap)JsonUtil.json2Obj((String)photos, HashMap.class);
            for (Map.Entry photoEntry : photoMap.entrySet()) {
                String photoKey = (String)photoEntry.getKey();
                String photoValue = (String)photoEntry.getValue();
                AccountImage accountImage = AccountImage.valueOfKey(photoKey);
                if (accountImage == null) continue;
                logger.trace("\u5f00\u59cb\u5904\u7406 {}", (Object)accountImage.getLabel());
                String downloadUrl = DepotnearbyQiNiuUtils.getAuditDownloadUrl(photoValue);
                images.add(new ZsgfAuditImgVo(downloadUrl, accountImage.getLabel()));
            }
            return images;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> readTxtFile(String filePath) {
        ArrayList imageNames = Lists.newArrayList();
        try {
            String encoding = "GBK";
            File file = new File(filePath);
            if (file.isFile() && file.exists()) {
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                BufferedReader bufferedReader = new BufferedReader(read);
                String lineTxt = null;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(lineTxt);
                    if ("".equals(sb.toString())) continue;
                    String[] tmp = sb.toString().split(",");
                    for (int i = 0; i < tmp.length; ++i) {
                        if ("".equals(tmp[i]) || tmp[i].length() <= 4) continue;
                        imageNames.add(tmp[i].replace("\"", ""));
                    }
                }
                read.close();
            } else {
                logger.debug("\u627e\u4e0d\u5230\u6307\u5b9a\u8f93\u5165\u6587\u4ef6, \u6587\u4ef6\u8def\u5f84: {}", (Object)filePath);
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u8f93\u5165\u6587\u4ef6\u5f02\u5e38");
            e.printStackTrace();
        }
        return imageNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream imageAddWaterMark(InputStream inputStream, String realFileName) {
        if (inputStream != null) {
            File temp = null;
            FileImageOutputStream os = null;
            try {
                int y;
                int x;
                BufferedImage srcImg = ImageIO.read(inputStream);
                BufferedImage buffImg = new BufferedImage(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 1);
                Graphics2D g = buffImg.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(srcImg.getScaledInstance(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 4), 0, 0, null);
                ImageIcon imgIcon = new ImageIcon(realFileName);
                Image img = imgIcon.getImage();
                if (((Image)srcImg).getWidth(null) == img.getWidth(null)) {
                    g.drawImage(img, 0, 0, null);
                } else if (((Image)srcImg).getWidth(null) > img.getWidth(null)) {
                    x = 0 + Math.abs((img.getWidth(null) - ((Image)srcImg).getWidth(null)) / 2);
                    y = 0 + Math.abs((img.getHeight(null) - ((Image)srcImg).getWidth(null)) / 2);
                    g.drawImage(img, x, y, null);
                } else {
                    x = 0 - Math.abs((img.getWidth(null) - ((Image)srcImg).getWidth(null)) / 2);
                    y = 0 - Math.abs((img.getHeight(null) - ((Image)srcImg).getHeight(null)) / 2);
                    g.drawImage(img, x, y, null);
                }
                g.setComposite(AlphaComposite.getInstance(3));
                g.dispose();
                temp = File.createTempFile("temp", "jgp");
                os = new FileImageOutputStream(temp);
                Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
                if (iter.hasNext()) {
                    ImageWriter writer = iter.next();
                    ImageWriteParam param = writer.getDefaultWriteParam();
                    param.setCompressionMode(2);
                    param.setCompressionQuality(0.9f);
                    writer.setOutput(os);
                    writer.write(null, new IIOImage(buffImg, null, null), param);
                    writer.dispose();
                }
                inputStream = new FileInputStream(temp);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (null != os) {
                        os.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                temp.delete();
            }
        }
        return inputStream;
    }

    public static void makeMath(String srcImgPath, String iconPath, String targerPath) {
        BufferedImage img = WaterMarkUtil.getBufferedImage(new File(srcImgPath));
        BufferedImage icon = WaterMarkUtil.getBufferedImage(new File(iconPath));
        if (img.getWidth() == icon.getWidth()) {
            WaterMarkUtil.markImageByIcon(iconPath, srcImgPath, targerPath, null, 0, 0);
        } else if (img.getWidth() > icon.getWidth()) {
            int x = 0 + Math.abs((icon.getWidth() - img.getWidth()) / 2);
            int y = 0 + Math.abs((icon.getHeight() - img.getHeight()) / 2);
            WaterMarkUtil.markImageByIcon(iconPath, srcImgPath, targerPath, null, x, y);
        } else {
            int x = 0 - Math.abs((icon.getWidth() - img.getWidth()) / 2);
            int y = 0 - Math.abs((icon.getHeight() - img.getHeight()) / 2);
            WaterMarkUtil.markImageByIcon(iconPath, srcImgPath, targerPath, null, x, y);
        }
    }

    public static void markImageByIcon(String iconPath, String srcImgPath, String targerPath) {
        WaterMarkUtil.markImageByIcon(iconPath, srcImgPath, targerPath, null, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markImageByIcon(String iconPath, String srcImgPath, String targerPath, Integer degree, Integer x, Integer y) {
        FileImageOutputStream os = null;
        try {
            BufferedImage srcImg = ImageIO.read(new File(srcImgPath));
            BufferedImage buffImg = new BufferedImage(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 1);
            Graphics2D g = buffImg.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(srcImg.getScaledInstance(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 4), 0, 0, null);
            if (null != degree) {
                g.rotate(Math.toRadians(degree.intValue()), (double)buffImg.getWidth() / 2.0, (double)buffImg.getHeight() / 2.0);
            }
            ImageIcon imgIcon = new ImageIcon(iconPath);
            Image img = imgIcon.getImage();
            float alpha = 1.0f;
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawImage(img, x, (int)y, null);
            g.setComposite(AlphaComposite.getInstance(3));
            g.dispose();
            os = new FileImageOutputStream(new File(targerPath));
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
            if (iter.hasNext()) {
                ImageWriter writer = iter.next();
                ImageWriteParam param = writer.getDefaultWriteParam();
                param.setCompressionMode(2);
                param.setCompressionQuality(0.9f);
                writer.setOutput(os);
                writer.write(null, new IIOImage(buffImg, null, null), param);
                writer.dispose();
                logger.debug("\u56fe\u7247\u751f\u6210\u6210\u529f, \u56fe\u7247\u5730\u5740\u4e3a: {}", (Object)targerPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markImageByIcon(String iconPath, InputStream srcImgPath, String targerPath, Integer degree) {
        FileImageOutputStream os = null;
        try {
            int y;
            int x;
            BufferedImage srcImg = ImageIO.read(srcImgPath);
            BufferedImage buffImg = new BufferedImage(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 1);
            Graphics2D g = buffImg.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(srcImg.getScaledInstance(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 4), 0, 0, null);
            if (null != degree) {
                g.rotate(Math.toRadians(degree.intValue()), (double)buffImg.getWidth() / 2.0, (double)buffImg.getHeight() / 2.0);
            }
            ImageIcon imgIcon = new ImageIcon(iconPath);
            Image img = imgIcon.getImage();
            float alpha = 1.0f;
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            if (((Image)srcImg).getWidth(null) == img.getWidth(null)) {
                g.drawImage(img, 0, 0, null);
            } else if (((Image)srcImg).getWidth(null) > img.getWidth(null)) {
                x = 0 + Math.abs((img.getWidth(null) - ((Image)srcImg).getWidth(null)) / 2);
                y = 0 + Math.abs((img.getHeight(null) - ((Image)srcImg).getWidth(null)) / 2);
                g.drawImage(img, x, y, null);
            } else {
                x = 0 - Math.abs((img.getWidth(null) - ((Image)srcImg).getWidth(null)) / 2);
                y = 0 - Math.abs((img.getHeight(null) - ((Image)srcImg).getHeight(null)) / 2);
                g.drawImage(img, x, y, null);
            }
            g.setComposite(AlphaComposite.getInstance(3));
            g.dispose();
            os = new FileImageOutputStream(new File(targerPath));
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
            if (iter.hasNext()) {
                ImageWriter writer = iter.next();
                ImageWriteParam param = writer.getDefaultWriteParam();
                param.setCompressionMode(2);
                param.setCompressionQuality(0.9f);
                writer.setOutput(os);
                writer.write(null, new IIOImage(buffImg, null, null), param);
                writer.dispose();
                logger.debug("\u56fe\u7247\u751f\u6210\u6210\u529f\uff0c\u56fe\u7247\u5730\u5740: {}", (Object)targerPath);
            }
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u6c34\u5370\u5f02\u5e38: {}", (Object)targerPath);
            e.printStackTrace();
        }
        finally {
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static BufferedImage getBufferedImage(File file) {
        BufferedImage img = null;
        try {
            if (null == file) {
                return null;
            }
            img = ImageIO.read(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return img;
    }

    public static void download(String urlString, String filename) throws Exception {
        int len;
        URL url = new URL(urlString);
        URLConnection con = url.openConnection();
        InputStream is = con.getInputStream();
        byte[] bs = new byte[1024];
        FileOutputStream os = new FileOutputStream(filename);
        while ((len = is.read(bs)) != -1) {
            ((OutputStream)os).write(bs, 0, len);
        }
        ((OutputStream)os).close();
        is.close();
    }

    public static InputStream download(String urlString) throws Exception {
        URL url = new URL(urlString);
        URLConnection con = url.openConnection();
        InputStream is = con.getInputStream();
        return is;
    }

    public static void makeWork(List<String> imageNames, String domain, String bucketName, String waterMarkRealFileName) throws Exception {
        String urlPrefix = "http://" + domain + "/";
        String targetDir = System.getProperty("user.dir") + File.separator + "temp";
        File file = new File(targetDir + File.separator + "mg");
        if (!file.exists() && !file.isDirectory()) {
            logger.debug("\u76ee\u5f55mg\u4e0d\u5b58\u5728.");
            file.mkdir();
        } else {
            logger.debug("\u76ee\u5f55mg\u5b58\u5728.");
        }
        int size = imageNames.size();
        logger.debug("\u5f85\u5904\u7406\u56fe\u7247\u603b\u5f20\u6570: {}", (Object)size);
        ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue<String>();
        if (CollectionUtils.isNotEmpty(imageNames)) {
            int count = 0;
            queue.addAll(imageNames);
            String imageName = null;
            while ((imageName = (String)queue.poll()) != null) {
                try {
                    InputStream srcImgPath = WaterMarkUtil.download(urlPrefix + imageName);
                    String targerPath = targetDir + File.separator + "mg" + File.separator + imageName;
                    WaterMarkUtil.markImageByIcon(waterMarkRealFileName, srcImgPath, targerPath, null);
                    QiniuUtil.put((String)bucketName, (InputStream)new FileInputStream(targerPath), (String)imageName, null);
                    logger.debug("\u5df2\u5b8c\u6210: {}/{}", (Object)(++count), (Object)size);
                }
                catch (Exception e) {
                    logger.error("\u5904\u7406\u5931\u8d25 \uff1a{}", (Object)imageName);
                    queue.offer(imageName);
                }
            }
            logger.debug("\u5168\u90e8\u5b8c\u6210, \u5df2\u5b8c\u6210\u603b\u5f20\u6570: {}", (Object)count);
        }
    }

    public static void makeWater(String domain, String imageListRealFileName, String bucketName, String waterMarkRealFileName) throws Exception {
        logger.debug("\u8bfb\u53d6\u6587\u4ef6\u8def\u5f84: {}", (Object)imageListRealFileName);
        List<String> imageNames = WaterMarkUtil.readTxtFile(imageListRealFileName);
        WaterMarkUtil.makeWork(imageNames, domain, bucketName, waterMarkRealFileName);
    }

    public static void main(String[] args) throws Exception {
    }

    static {
        Properties properties = null;
        try {
            properties = ConfigUtils.loadFromFileOrZooKeeper((String)"/depotnearby/config/qiniu.properties", (String)"/qiniu.properties");
        }
        catch (Exception e) {
            logger.info("\u6ca1\u6709\u53d1\u73b0qiniu\u914d\u7f6e\u6587\u4ef6.", (Throwable)e);
        }
        if (properties != null) {
            buckets.add(new QiniuBucketVo(QiniuBucket.PRODUCT.getType(), properties.getProperty(QiniuBucket.PRODUCT.getBucketNameKey()), properties.getProperty(QiniuBucket.PRODUCT.getDomainKey())));
            buckets.add(new QiniuBucketVo(QiniuBucket.AVATAR.getType(), properties.getProperty(QiniuBucket.AVATAR.getBucketNameKey()), properties.getProperty(QiniuBucket.AVATAR.getDomainKey())));
            buckets.add(new QiniuBucketVo(QiniuBucket.SOURCE.getType(), properties.getProperty(QiniuBucket.SOURCE.getBucketNameKey()), properties.getProperty(QiniuBucket.SOURCE.getDomainKey())));
            buckets.add(new QiniuBucketVo(QiniuBucket.AUDIT.getType(), properties.getProperty(QiniuBucket.AUDIT.getBucketNameKey()), properties.getProperty(QiniuBucket.AUDIT.getDomainKey())));
        }
    }
}

