/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.vo.geo;

import com.depotnearby.common.model.geo.IArea;
import com.depotnearby.vo.geo.polygon.Point;
import com.depotnearby.vo.geo.polygon.Polygon;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolygonHolder
implements Serializable {
    private static final long serialVersionUID = -927514729298269196L;
    private static final Logger logger = LoggerFactory.getLogger(PolygonHolder.class);
    private Integer id;
    private int level;
    private String name;
    private String cityCode;
    private int weight;
    private Point center;
    public List<Polygon> polygons = new ArrayList<Polygon>();
    private PolygonHolder parent;
    private List<PolygonHolder> children;

    private PolygonHolder() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public PolygonHolder getParent() {
        return this.parent;
    }

    public void setParent(PolygonHolder parent) {
        this.parent = parent;
    }

    public Point getCenter() {
        return this.center;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public static PolygonHolder build(IArea area, String coordinate) {
        if (StringUtils.isNotBlank((CharSequence)coordinate)) {
            PolygonHolder holder = new PolygonHolder();
            try {
                holder.id = area.getId();
                holder.level = area.getLevel();
                holder.name = area.getName();
                int n = holder.weight = area.getWeight() == null ? 1 : area.getWeight();
                if (area.getLevel() == 3) {
                    holder.cityCode = area.getCode();
                }
                boolean calcCenter = false;
                if (area.getLon() == null || area.getLat() == null) {
                    calcCenter = true;
                } else {
                    holder.center = new Point(area.getLon().doubleValue(), area.getLat().doubleValue());
                }
                holder.buildFromCoordinate(coordinate, calcCenter);
                if (calcCenter) {
                    System.out.println("update geo_business set lat=" + holder.center.y + " ,lon=" + holder.center.x + " where id=" + area.getId());
                }
                return holder;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("build polygon level:{} id:{} error:{}", new Object[]{area.getLevel(), area.getId(), e.getMessage()});
                return null;
            }
        }
        return null;
    }

    private void buildFromCoordinate(String coordinate, boolean calcCenter) {
        String[] arr = coordinate.split("\\|");
        double maxlat = Double.MIN_VALUE;
        double minlat = Double.MAX_VALUE;
        double maxlon = Double.MIN_VALUE;
        double minlon = Double.MAX_VALUE;
        for (String s : arr) {
            String[] parr;
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            Polygon.Builder builder = new Polygon.Builder();
            for (String p : parr = s.split(";")) {
                int idx = p.indexOf(44);
                double lon = Double.parseDouble(p.substring(0, idx).trim());
                double lat = Double.parseDouble(p.substring(idx + 1).trim());
                if (calcCenter && this.center == null) {
                    maxlat = Math.max(maxlat, lat);
                    minlat = Math.min(minlat, lat);
                    maxlon = Math.max(maxlon, lon);
                    minlon = Math.min(minlon, lon);
                }
                Point point = new Point(lon, lat);
                builder.addVertex(point);
            }
            if (calcCenter && this.center == null) {
                this.center = new Point((minlon + maxlon) / 2.0, (minlat + maxlat) / 2.0);
            }
            this.polygons.add(builder.close().build());
        }
    }

    public static PolygonHolder buildTemp(String coordinate) {
        PolygonHolder h = new PolygonHolder();
        h.buildFromCoordinate(coordinate, false);
        return h;
    }

    public static PolygonHolder buildWithCenter(IArea area) {
        PolygonHolder holder = new PolygonHolder();
        try {
            holder.id = area.getId();
            holder.level = area.getLevel();
            holder.name = area.getName();
            holder.weight = area.getWeight();
            if (area.getLevel() == 3) {
                holder.cityCode = area.getCode();
            }
            double lon = area.getLon().doubleValue();
            double lat = area.getLat().doubleValue();
            holder.center = new Point(lon, lat);
            Polygon.Builder builder = new Polygon.Builder();
            builder.addVertex(new Point(lon - (double)0.01f, lat + (double)0.01f));
            builder.addVertex(new Point(lon + (double)0.01f, lat + (double)0.01f));
            builder.addVertex(new Point(lon + (double)0.01f, lat - (double)0.01f));
            builder.addVertex(new Point(lon - (double)0.01f, lat - (double)0.01f));
            holder.polygons.add(builder.close().build());
            return holder;
        }
        catch (Exception e) {
            logger.error("build polygon level:{} id:{} error:{}", new Object[]{area.getLevel(), area.getId(), e.getMessage()});
            return null;
        }
    }

    public void addChild(PolygonHolder child) {
        if (this.children == null) {
            this.children = new ArrayList<PolygonHolder>();
        }
        this.children.add(child);
        child.parent = this;
    }

    public boolean contains(Point p) {
        for (Polygon pol : this.polygons) {
            if (!pol.contains(p)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(BigDecimal lat, BigDecimal lon) {
        return this.contains(new Point(lon.doubleValue(), lat.doubleValue()));
    }

    public double simplifyDistance(BigDecimal lat, BigDecimal lon) {
        double latdis = lat.doubleValue() - this.center.y;
        double londis = lon.doubleValue() - this.center.x;
        return latdis * latdis + londis * londis;
    }

    public static double simplifyDistance(Point p, Point p1) {
        double x = p.x - p1.x;
        double y = p.y - p1.y;
        return Math.sqrt(x * x + y * y);
    }

    public PolygonHolder find(BigDecimal lat, BigDecimal lon, boolean isGreed) {
        return this.find(new Point(lon.doubleValue(), lat.doubleValue()), isGreed);
    }

    public PolygonHolder find(Point p, boolean isGreed) {
        if (this.contains(p)) {
            if (this.children != null && !this.children.isEmpty()) {
                PolygonHolder nearest;
                for (PolygonHolder child : this.children) {
                    PolygonHolder h = child.find(p, isGreed);
                    if (h == null) continue;
                    return h;
                }
                if (isGreed && (nearest = this.nearestChild(p)) != null) {
                    return nearest;
                }
            }
            return this;
        }
        return null;
    }

    public PolygonHolder nearestChild(Point p) {
        double min = Double.MAX_VALUE;
        PolygonHolder result = null;
        for (PolygonHolder child : this.children) {
            double dis = PolygonHolder.simplifyDistance(child.center, p);
            if (!(dis < min)) continue;
            result = child;
            min = dis;
        }
        return result;
    }

    public PolygonHolder inChild(Point p) {
        for (PolygonHolder child : this.children) {
            if (!child.contains(p)) continue;
            return child;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        double lon = 104.06534576416016;
        double lat = 30.63327980041504;
        Polygon.Builder builder = new Polygon.Builder();
        builder.addVertex(new Point(lon - (double)0.01f, lat + (double)0.01f));
        builder.addVertex(new Point(lon + (double)0.01f, lat + (double)0.01f));
        builder.addVertex(new Point(lon + (double)0.01f, lat - (double)0.01f));
        builder.addVertex(new Point(lon - (double)0.01f, lat - (double)0.01f));
        Polygon p = builder.close().build();
        System.out.println(p.contains(new Point(104.07112121582031, 30.63935661315918)));
    }
}

