/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.vo.geo.polygon;

import com.depotnearby.vo.geo.polygon.Point;

public class Line {
    private final Point _start;
    private final Point _end;
    private double _a = Double.NaN;
    private double _b = Double.NaN;
    private boolean _vertical = false;

    public Line(Point start, Point end) {
        this._start = start;
        this._end = end;
        if (this._end.x - this._start.x != 0.0) {
            this._a = (this._end.y - this._start.y) / (this._end.x - this._start.x);
            this._b = this._start.y - this._a * this._start.x;
        } else {
            this._vertical = true;
        }
    }

    public boolean isInside(Point point) {
        double minY;
        double maxX = this._start.x > this._end.x ? this._start.x : this._end.x;
        double minX = this._start.x < this._end.x ? this._start.x : this._end.x;
        double maxY = this._start.y > this._end.y ? this._start.y : this._end.y;
        double d = minY = this._start.y < this._end.y ? this._start.y : this._end.y;
        return point.x >= minX && point.x <= maxX && point.y >= minY && point.y <= maxY;
    }

    public boolean isVertical() {
        return this._vertical;
    }

    public double getA() {
        return this._a;
    }

    public double getB() {
        return this._b;
    }

    public Point getStart() {
        return this._start;
    }

    public Point getEnd() {
        return this._end;
    }

    public String toString() {
        return String.format("%s-%s", this._start.toString(), this._end.toString());
    }
}

