/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.vo.mq;

import com.depotnearby.common.util.JsonUtil;
import com.depotnearby.ro.mq.MQMessageRo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MQMessage
implements Serializable {
    private static final long serialVersionUID = -3500467693515230755L;
    private String queueName;
    private String dataClass;
    private String data;
    private Long retryPeriod;
    private Integer failedCount;
    private Integer maxFailedCount;
    private String mailTo;

    @Deprecated
    public MQMessage() {
    }

    public MQMessage(String queueName, Object data, Long retryPeriod, Integer maxFailedCount, String mailTo) {
        this.queueName = queueName;
        this.dataClass = data == null ? null : data.getClass().getName();
        this.data = JsonUtil.obj2Json((Object)data);
        this.retryPeriod = retryPeriod;
        this.failedCount = 0;
        this.maxFailedCount = maxFailedCount;
        this.mailTo = mailTo;
    }

    public MQMessage(MQMessageRo mqMessageRo) {
        this.queueName = mqMessageRo.getQueueName();
        this.dataClass = mqMessageRo.getDataClass();
        this.data = mqMessageRo.getData();
        this.retryPeriod = mqMessageRo.getRetryPeriod();
        this.failedCount = mqMessageRo.getFailedCount();
        this.maxFailedCount = mqMessageRo.getMaxFailedCount();
        this.mailTo = mqMessageRo.getMailTo();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getDataClass() {
        return this.dataClass;
    }

    public String getData() {
        return this.data;
    }

    @JsonIgnore
    public Object dataToObject() {
        try {
            return this.data == null ? null : JsonUtil.json2Obj((String)this.data, Class.forName(this.dataClass));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Long getRetryPeriod() {
        return this.retryPeriod;
    }

    public Integer getFailedCount() {
        return this.failedCount;
    }

    public Integer getMaxFailedCount() {
        return this.maxFailedCount;
    }

    public String getMailTo() {
        return this.mailTo;
    }

    @Deprecated
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Deprecated
    public void setDataClass(String dataClass) {
        this.dataClass = dataClass;
    }

    @Deprecated
    public void setData(String data) {
        this.data = data;
    }

    @Deprecated
    public void setRetryPeriod(Long retryPeriod) {
        this.retryPeriod = retryPeriod;
    }

    @Deprecated
    public void setFailedCount(Integer failedCount) {
        this.failedCount = failedCount;
    }

    @Deprecated
    public void setMaxFailedCount(Integer maxFailedCount) {
        this.maxFailedCount = maxFailedCount;
    }

    @Deprecated
    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

