/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.vo.search;

import com.depotnearby.vo.geo.GeoFindResult;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;

public abstract class Position
implements Serializable {
    protected Map<Integer, String> businessMap;
    protected GeoFindResult geoFindResult;
    private String districtId = "";
    private String areaIds = "";
    private String businessIds = "";
    private String areaNames = "";

    public Map<Integer, String> getBusinessMap() {
        return this.businessMap;
    }

    public void setBusinessMap(Map<Integer, String> businessMap) {
        this.businessMap = businessMap;
    }

    public GeoFindResult getGeoFindResult() {
        return this.geoFindResult;
    }

    public void setGeoFindResult(GeoFindResult geoFindResult) {
        this.geoFindResult = geoFindResult;
    }

    public abstract BigDecimal getLat();

    public abstract BigDecimal getLon();

    public void prepare() {
        StringBuilder sbIds = new StringBuilder();
        StringBuilder sbNames = new StringBuilder();
        if (this.geoFindResult != null) {
            if (this.geoFindResult.cityId != null) {
                sbIds.append(this.geoFindResult.cityId).append(" ");
            }
            if (this.geoFindResult.districtId != null) {
                this.districtId = this.geoFindResult.districtId.toString();
                sbIds.append(this.geoFindResult.districtId).append(" ");
            }
        }
        if (this.businessMap != null) {
            for (Map.Entry<Integer, String> entry : this.businessMap.entrySet()) {
                sbIds.append(entry.getKey()).append(" ");
                sbNames.append(entry.getValue()).append(" ");
                this.businessIds = this.businessIds + entry.getKey() + " ";
            }
        }
        this.areaIds = sbIds.toString();
        if (this.geoFindResult != null && this.geoFindResult.areaNames != null && this.geoFindResult.areaNames.size() > 0) {
            for (String s : this.geoFindResult.areaNames) {
                sbNames.append(s).append(" ");
            }
        }
        this.areaNames = sbNames.toString();
    }

    public String getDistrictId() {
        return this.districtId;
    }

    public String getAreaIds() {
        return this.areaIds;
    }

    public String getAreaNames() {
        return this.areaNames;
    }

    public String getBusinessIds() {
        return this.businessIds;
    }

    public void setBusinessIds(String businessIds) {
        this.businessIds = businessIds;
    }
}

