/*
 * Decompiled with CFR 0.152.
 */
package com.wechat;

import com.wechat.exceptions.MissingResourceException;
import com.wechat.lang.CertificateLoader;
import com.wechat.lang.CheckName;
import com.wechat.lang.Signer;
import com.wechat.lang.TradeType;
import com.wechat.req.CloseOrder;
import com.wechat.req.OrderQuery;
import com.wechat.req.OrderRefund;
import com.wechat.req.RefundQuery;
import com.wechat.req.Transfer;
import com.wechat.req.TransferQuery;
import com.wechat.req.UnifiedOrder;
import com.wechat.req.WechatPayRequestBase;
import java.io.InputStreamReader;
import java.util.Properties;
import org.codelogger.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatPayFactory {
    private static final Logger logger = LoggerFactory.getLogger(WeChatPayFactory.class);
    private static final int NONCE_STRING_LENGTH = 16;
    public static final String CONFIG_PATH = "/wechatPay.properties";
    public static final String UTF_8 = "utf-8";
    private static Properties conf;

    private WeChatPayFactory() {
        conf = new Properties();
        try {
            logger.info("load wechat payment configurations.");
            conf.load(new InputStreamReader(WeChatPayFactory.class.getResourceAsStream(CONFIG_PATH), UTF_8));
        }
        catch (Exception ex) {
            throw new MissingResourceException(String.format("Failed to load conf resource [%s]", CONFIG_PATH), ex);
        }
    }

    public static WeChatPayFactory newInstance() {
        return WeChatPayFactoryHolder.instance;
    }

    public Signer newSigner(String appId) {
        return new Signer(conf, this.getPropertyByAppId("key", appId));
    }

    public UnifiedOrder newUnifiedOrder(String appId, String outTradeNo, String body, Integer totalFee, String clientIp, TradeType tradeType, String timeExpire, String openid) {
        UnifiedOrder unifiedOrder = new UnifiedOrder(outTradeNo, body, totalFee, clientIp, tradeType, timeExpire, openid);
        this.setConfigurations(appId, unifiedOrder);
        unifiedOrder.setProperty("attach", this.getFixedAppId(appId));
        return unifiedOrder;
    }

    public OrderQuery newOrderQuery(String appId, String transactionId, String outTradeNo) {
        OrderQuery orderQuery = new OrderQuery(transactionId, outTradeNo);
        this.setConfigurations(appId, orderQuery);
        return orderQuery;
    }

    public CloseOrder newCloseOrder(String appId, String outTradeNo) {
        CloseOrder closeOrder = new CloseOrder(outTradeNo);
        this.setConfigurations(appId, closeOrder);
        return closeOrder;
    }

    public OrderRefund newOrderRefund(String appId, String transactionId, String outTradeNo, String outRefundNo, Integer totalFee, Integer refundFee) {
        OrderRefund refundOrder = new OrderRefund(transactionId, outTradeNo, outRefundNo, totalFee, refundFee);
        refundOrder.setSslContext(new CertificateLoader(this.getPropertyByAppId("LOAD_IDENTIFICATION", appId), this.getPropertyByAppId("mch_id", appId)).getSSLContext());
        this.setConfigurations(appId, refundOrder);
        refundOrder.setProperty("op_user_id", this.getPropertyByAppId("mch_id", appId));
        return refundOrder;
    }

    public RefundQuery newRefundQuery(String appId, String refundId, String outRefundNo) {
        RefundQuery refundQuery = new RefundQuery(refundId, outRefundNo);
        this.setConfigurations(appId, refundQuery);
        return refundQuery;
    }

    public Transfer newTransfer(String appId, String partnerTradeNo, String openid, Integer amount, String desc, CheckName checkName, String receiverName) {
        Transfer transfer = new Transfer(partnerTradeNo, openid, amount, desc, checkName, receiverName);
        transfer.setSslContext(new CertificateLoader(this.getPropertyByAppId("LOAD_IDENTIFICATION", appId), this.getPropertyByAppId("mch_id", appId)).getSSLContext());
        this.setConfigurations(appId, transfer);
        transfer.setProperty("mch_appid", this.getFixedAppId(appId));
        transfer.setProperty("mchid", this.getPropertyByAppId("mch_id", appId));
        transfer.setProperty("spbill_create_ip", conf.getProperty("spbill_create_ip"));
        return transfer;
    }

    public TransferQuery newTransferQuery(String appId, String partnerTradeNo) {
        TransferQuery refundQuery = new TransferQuery(partnerTradeNo);
        this.setConfigurations(appId, refundQuery);
        refundQuery.setSslContext(new CertificateLoader(this.getPropertyByAppId("LOAD_IDENTIFICATION", appId), this.getPropertyByAppId("mch_id", appId)).getSSLContext());
        return refundQuery;
    }

    private void setConfigurations(String appId, WechatPayRequestBase wechatPayRequestBase) {
        wechatPayRequestBase.setProperties(conf);
        wechatPayRequestBase.setProperty("appid", this.getFixedAppId(appId));
        wechatPayRequestBase.setProperty("mch_id", this.getPropertyByAppId("mch_id", appId));
        wechatPayRequestBase.setProperty("key", this.getPropertyByAppId("key", appId));
        wechatPayRequestBase.setProperty("nonce_str", StringUtils.getRandomPasswordString((int)16));
    }

    private String getFixedAppId(String appId) {
        return StringUtils.isBlank((String)appId) ? conf.getProperty("appid.default") : appId;
    }

    private String getPropertyByAppId(String propertyKey, String appId) {
        String fixedAppId = this.getFixedAppId(appId);
        return conf.getProperty(propertyKey + "." + fixedAppId);
    }

    private static class WeChatPayFactoryHolder {
        static WeChatPayFactory instance = new WeChatPayFactory();

        private WeChatPayFactoryHolder() {
        }
    }
}

