/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.lang;

import java.io.InputStream;
import java.security.KeyStore;
import java.util.MissingResourceException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class CertificateLoader {
    public static final String ALGORITHM = "TLSv1";
    public KeyStore identification;
    public String passPhrase;

    public CertificateLoader(String identificationPath, String pws) {
        this.passPhrase = pws;
        this.loadIdentification(identificationPath, pws);
    }

    public SSLContext getSSLContext() {
        try {
            KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmFactory.init(this.identification, this.passPhrase.toCharArray());
            KeyManager[] km = kmFactory.getKeyManagers();
            SSLContext sslCtx = SSLContext.getInstance(ALGORITHM);
            sslCtx.init(km, null, null);
            return sslCtx;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void loadIdentification(String resourcePath, String pwd) {
        try {
            InputStream stream = this.getClass().getResourceAsStream(resourcePath);
            if (stream == null) {
                throw new MissingResourceException("Load identification failed.", CertificateLoader.class.getName(), resourcePath);
            }
            this.identification = KeyStore.getInstance("PKCS12");
            this.identification.load(stream, pwd.toCharArray());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

