/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.lang;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.wechat.exceptions.SignException;
import com.wechat.lang.SignIgnore;
import com.wechat.lang.SignProperty;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.codelogger.utils.ArrayUtils;
import org.codelogger.utils.CollectionUtils;
import org.codelogger.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Signer {
    private static final Logger logger = LoggerFactory.getLogger(Signer.class);
    private final String key;

    public Signer(Properties properties, String key) throws IllegalArgumentException {
        Signer.validateProperties(properties);
        this.key = key;
    }

    public String sign(Object object) {
        Class<?> aClass = object.getClass();
        Properties properties = new Properties();
        Object[] declaredFields = aClass.getDeclaredFields();
        if (ArrayUtils.isNotEmpty((Object[])declaredFields)) {
            try {
                for (Object declaredField : declaredFields) {
                    if (((AccessibleObject)declaredField).isAnnotationPresent(SignIgnore.class)) continue;
                    String name = ((Field)declaredField).getName();
                    ((Field)declaredField).setAccessible(true);
                    Object value = ((Field)declaredField).get(object);
                    SignProperty signProperty = ((Field)declaredField).getAnnotation(SignProperty.class);
                    if (signProperty != null && StringUtils.isNotBlank((String)signProperty.value())) {
                        properties.put(signProperty.value(), value);
                        continue;
                    }
                    properties.put(name, value);
                }
                return this.sign(properties);
            }
            catch (Exception e) {
                throw new SignException(e);
            }
        }
        throw new IllegalArgumentException("Argument object not have any fields.");
    }

    public String sign(Properties properties) throws IllegalArgumentException {
        return Signer.sign(properties, this.key);
    }

    public String sign(TreeSet<String> signParamNames, Properties properties) throws IllegalArgumentException {
        return Signer.sign(signParamNames, properties, this.key);
    }

    public static String sign(Properties properties, String key) throws IllegalArgumentException {
        Signer.validateProperties(properties);
        Signer.validateKey(key);
        Set<Object> propertiesKeySets = properties.keySet();
        TreeSet signParamNames = Sets.newTreeSet();
        for (Object propertiesKeySet : propertiesKeySets) {
            String propertyKey = propertiesKeySet.toString();
            if (Objects.equals("key", propertyKey) || Objects.equals("sign", propertyKey)) continue;
            signParamNames.add(propertyKey);
        }
        return Signer.sign(signParamNames, properties, key);
    }

    public static String sign(TreeSet<String> signParamNames, Properties properties, String key) throws IllegalArgumentException {
        Signer.validateSignParamNames(signParamNames);
        Signer.validateProperties(properties);
        Signer.validateKey(key);
        ArrayList keyValuePair = Lists.newArrayList();
        for (String signParamName : signParamNames) {
            String signParamValue = properties.getProperty(signParamName);
            if (signParamValue == null) continue;
            keyValuePair.add(signParamName + "=" + signParamValue);
        }
        keyValuePair.add("key=" + key);
        String finalParams = org.apache.commons.lang3.StringUtils.join((Iterable)keyValuePair, (String)"&");
        if (logger.isDebugEnabled()) {
            logger.debug("sign keyValuePairs:[{}].", (Object)finalParams);
        }
        return Signer.encodedByMD5(finalParams).toUpperCase();
    }

    private static void validateSignParamNames(TreeSet<String> signParamNames) {
        if (CollectionUtils.isEmpty(signParamNames)) {
            throw new IllegalArgumentException("Argument signParamNames can not be empty.");
        }
    }

    private static void validateProperties(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Argument properties can not be empty.");
        }
    }

    private static void validateKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("Argument key can not be blank, key required to sign.");
        }
    }

    private static String encodedByMD5(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(password.getBytes());
            return Signer.byte2string(md.digest());
        }
        catch (Exception e) {
            return password;
        }
    }

    private static String byte2string(byte[] b) {
        StringBuffer hs = new StringBuffer(100);
        for (int n = 0; n < b.length; ++n) {
            hs.append(Signer.byte2fex(b[n]));
        }
        return hs.toString();
    }

    private static String byte2fex(byte ib) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        String s = new String(ob);
        return s;
    }
}

