/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.req;

import com.google.common.collect.Sets;
import com.wechat.req.WechatPayRequestBase;
import com.wechat.res.CloseOrderResponse;
import java.util.Arrays;
import java.util.TreeSet;
import org.codelogger.utils.StringUtils;

public class CloseOrder
extends WechatPayRequestBase<CloseOrderResponse> {
    private static final String API_URL = "https://api.mch.weixin.qq.com/pay/closeorder";
    public static final TreeSet<String> KEYS_PARAM_NAME = Sets.newTreeSet(Arrays.asList("appid", "mch_id", "out_trade_no", "nonce_str", "sign"));

    public CloseOrder(String outTradeNo) {
        if (StringUtils.isBlank((String)outTradeNo)) {
            throw new IllegalArgumentException("Argument transactionId and outTradeNo can not be empty.");
        }
        this.setProperty("out_trade_no", outTradeNo);
    }

    @Override
    protected String getApiUrl() {
        return API_URL;
    }

    @Override
    protected CloseOrderResponse parseResponse(String responseBody) {
        return new CloseOrderResponse(responseBody);
    }

    @Override
    protected TreeSet<String> getSignParamNames() {
        return KEYS_PARAM_NAME;
    }
}

