/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.req;

import com.google.common.collect.Sets;
import com.wechat.req.WechatPayRequestBase;
import com.wechat.res.OrderQueryResponse;
import java.util.Arrays;
import java.util.TreeSet;
import org.codelogger.utils.StringUtils;

public class OrderQuery
extends WechatPayRequestBase<OrderQueryResponse> {
    public static final String API_URL = "https://api.mch.weixin.qq.com/pay/orderquery";
    public static final TreeSet<String> KEYS_PARAM_NAME = Sets.newTreeSet(Arrays.asList("transaction_id", "out_trade_no", "appid", "mch_id", "nonce_str", "sign"));

    public OrderQuery(String transactionId, String outTradeNo) {
        if (StringUtils.isBlank((String)transactionId) && StringUtils.isBlank((String)outTradeNo)) {
            throw new IllegalArgumentException("Argument transactionId and outTradeNo can not be both empty.");
        }
        this.setProperty("transaction_id", transactionId);
        this.setProperty("out_trade_no", outTradeNo);
    }

    @Override
    protected String getApiUrl() {
        return API_URL;
    }

    @Override
    protected OrderQueryResponse parseResponse(String responseBody) {
        return new OrderQueryResponse(responseBody);
    }

    @Override
    protected TreeSet<String> getSignParamNames() {
        return KEYS_PARAM_NAME;
    }
}

