/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.req;

import com.google.common.collect.Sets;
import com.wechat.lang.SimpleHttpClient;
import com.wechat.req.WechatPayRequestBase;
import com.wechat.res.RefundResponse;
import java.util.Arrays;
import java.util.TreeSet;
import javax.net.ssl.SSLContext;
import org.codelogger.utils.StringUtils;
import org.codelogger.utils.ValueUtils;

public class OrderRefund
extends WechatPayRequestBase<RefundResponse> {
    private static final String API_URL = "https://api.mch.weixin.qq.com/secapi/pay/refund";
    public static final TreeSet<String> KEYS_PARAM_NAME = Sets.newTreeSet(Arrays.asList("appid", "mch_id", "transaction_id", "out_trade_no", "out_refund_no", "total_fee", "refund_fee", "op_user_id", "nonce_str", "sign"));
    private SSLContext sslContext;

    public OrderRefund(String transactionId, String outTradeNo, String outRefundNo, Integer totalFee, Integer refundFee) {
        if (StringUtils.isBlank((String)transactionId) && StringUtils.isBlank((String)outTradeNo)) {
            throw new IllegalArgumentException("Argument transactionId and outTradeNo can not be both empty.");
        }
        if (StringUtils.isBlank((String)outRefundNo)) {
            throw new IllegalArgumentException("Argument outRefundNo can not be blank.");
        }
        if (ValueUtils.getValue((Integer)totalFee) < 1) {
            throw new IllegalArgumentException("Argument totalFee can not less than 1.");
        }
        if (ValueUtils.getValue((Integer)refundFee) < 1) {
            throw new IllegalArgumentException("Argument refundFee can not less than 1.");
        }
        if (refundFee > totalFee) {
            throw new IllegalArgumentException("Argument refundFee can not greater than totalFee.");
        }
        this.setProperty("transaction_id", transactionId);
        this.setProperty("out_trade_no", outTradeNo);
        this.setProperty("out_refund_no", outRefundNo);
        this.setProperty("total_fee", totalFee.toString());
        this.setProperty("refund_fee", refundFee.toString());
    }

    @Override
    protected SimpleHttpClient getSimpleHttpClient() {
        if (this.sslContext == null) {
            throw new IllegalArgumentException("sslContext can not be null");
        }
        return new SimpleHttpClient(this.sslContext);
    }

    @Override
    protected String getApiUrl() {
        return API_URL;
    }

    @Override
    protected RefundResponse parseResponse(String responseBody) {
        return new RefundResponse(responseBody);
    }

    @Override
    protected TreeSet<String> getSignParamNames() {
        return KEYS_PARAM_NAME;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }
}

