/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.req;

import com.google.common.collect.Sets;
import com.wechat.lang.TradeType;
import com.wechat.req.WechatPayRequestBase;
import com.wechat.res.UnifiedOrderResponse;
import java.util.Arrays;
import java.util.TreeSet;
import org.codelogger.utils.StringUtils;
import org.codelogger.utils.ValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedOrder
extends WechatPayRequestBase<UnifiedOrderResponse> {
    private static final Logger logger = LoggerFactory.getLogger((String)"UnifiedOrder");
    public static final String API_URL = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    public static final TreeSet<String> KEYS_PARAM_NAME = Sets.newTreeSet(Arrays.asList("body", "openid", "out_trade_no", "product_id", "spbill_create_ip", "total_fee", "trade_type", "appid", "attach", "device_info", "goods_tag", "mch_id", "nonce_str", "notify_url", "sign", "time_start", "time_expire"));

    public UnifiedOrder(String outTradeNo, String body, Integer totalFee, String clientIp, TradeType tradeType, String timeExpire, String openid) {
        if (StringUtils.isBlank((String)outTradeNo)) {
            throw new IllegalArgumentException("outTradeNo can not be empty.");
        }
        if (StringUtils.isBlank((String)body)) {
            throw new IllegalArgumentException("body can not be empty.");
        }
        if (ValueUtils.getValue((Integer)totalFee) < 1) {
            throw new IllegalArgumentException("totalFee can not less than 1.");
        }
        if (StringUtils.isBlank((String)clientIp)) {
            throw new IllegalArgumentException("clientIp can not be empty.");
        }
        if (tradeType == null) {
            throw new IllegalArgumentException("tradeType can not be null.");
        }
        if (timeExpire != null && !timeExpire.matches("^\\d{14}$")) {
            throw new IllegalArgumentException("timeExpire format pattern is 'yyyyMMddHHmmss'");
        }
        this.setProperty("out_trade_no", outTradeNo);
        this.setProperty("body", org.apache.commons.lang3.StringUtils.left((String)body, (int)30));
        this.setProperty("total_fee", totalFee.toString());
        this.setProperty("spbill_create_ip", clientIp);
        this.setProperty("trade_type", tradeType.name());
        this.setProperty("time_expire", timeExpire);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)openid)) {
            this.setProperty("openid", openid);
        }
    }

    @Override
    protected String getApiUrl() {
        return API_URL;
    }

    @Override
    protected TreeSet<String> getSignParamNames() {
        return KEYS_PARAM_NAME;
    }

    @Override
    protected UnifiedOrderResponse parseResponse(String responseXml) {
        return new UnifiedOrderResponse(responseXml);
    }
}

