/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.req;

import com.google.common.collect.Lists;
import com.wechat.exceptions.HttpException;
import com.wechat.lang.Signer;
import com.wechat.lang.SimpleHttpClient;
import com.wechat.lang.XmlBuilder;
import com.wechat.res.WechatPayResponseBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WechatPayRequestBase<T extends WechatPayResponseBase> {
    private static final Logger logger = LoggerFactory.getLogger(WechatPayRequestBase.class);
    public static final String UTF_8 = "utf-8";
    protected Properties conf = new Properties();

    public void setProperties(Properties properties) {
        for (Object key : properties.keySet()) {
            String keyString = key.toString();
            this.conf.setProperty(keyString, properties.getProperty(keyString));
        }
    }

    public String getProperty(String key) {
        return this.conf.getProperty(key);
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.conf.setProperty(key, value);
        }
    }

    public T execute() {
        try {
            this.sign();
            String xmlBody = this.buildXmlBody();
            if (logger.isDebugEnabled()) {
                logger.debug(xmlBody);
            }
            ContentType textXml = ContentType.create((String)ContentType.TEXT_XML.getMimeType(), (String)UTF_8);
            String responseBody = this.getSimpleHttpClient().doPost(this.getApiUrl(), textXml, xmlBody);
            return this.parseResponse(responseBody);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    protected abstract String getApiUrl();

    protected abstract T parseResponse(String var1);

    protected abstract TreeSet<String> getSignParamNames();

    protected SimpleHttpClient getSimpleHttpClient() {
        return new SimpleHttpClient();
    }

    private void sign() {
        String sign = Signer.sign(this.getSignParamNames(), this.conf, this.getProperty("key"));
        this.setProperty("sign", sign);
    }

    private String buildXmlBody() {
        TreeSet<String> signParamNames = this.getSignParamNames();
        ArrayList data = Lists.newArrayList();
        for (String key : signParamNames) {
            String v;
            if (Objects.equals(key, "sign") || (v = this.conf.getProperty(key)) == null) continue;
            data.add(new DefaultKeyValue((Object)key, (Object)v));
        }
        data.add(new DefaultKeyValue((Object)"sign", (Object)this.conf.getProperty("sign")));
        return new XmlBuilder(data).buildXmlBody();
    }
}

