/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.util;

import com.depotnearby.common.util.JsonUtil;
import com.depotnearby.exception.CommonException;
import com.depotnearby.util.StringTool;
import com.wechat.lang.WeChatAccessToken;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatHelper {
    private static final Logger logger = LoggerFactory.getLogger(WeChatHelper.class);

    private WeChatHelper() {
    }

    public static String buildWeixinAuthRedirectUrl(String weixinDomain, String weixinAppId, String type) {
        StringBuilder sb = new StringBuilder();
        String targetUrl = "http://" + weixinDomain + "/weixin/gate.do";
        sb.append("https://open.weixin.qq.com/connect/oauth2/authorize?");
        sb.append("appid=").append(weixinAppId);
        sb.append("&redirect_uri=").append(StringTool.encodedUrl(targetUrl));
        sb.append("&response_type=code");
        sb.append("&scope=").append("snsapi_base");
        sb.append("&state=").append(type).append("#wechat_redirect");
        return sb.toString();
    }

    public static String buildWechatBaseOauthRedirectUrl(String redirectURI, String appid, String state) {
        StringBuilder sb = new StringBuilder();
        sb.append("https://open.weixin.qq.com/connect/oauth2/authorize?");
        sb.append("appid=").append(appid);
        sb.append("&redirect_uri=").append(StringTool.encodedUrl(redirectURI));
        sb.append("&response_type=code");
        sb.append("&scope=").append("snsapi_base");
        sb.append("&state=").append(state).append("#wechat_redirect");
        return sb.toString();
    }

    public static WeChatAccessToken getAccessToken(String appId, String appSecret) throws CommonException {
        String tokenGetUrl = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", appId, appSecret);
        try {
            String accessTokenResponse = IOUtils.toString((URI)new URI(tokenGetUrl));
            logger.debug("Received weixin response:'{}' from url '{}'", (Object)accessTokenResponse, (Object)accessTokenResponse);
            if (StringUtils.isNotBlank((CharSequence)accessTokenResponse)) {
                HashMap accessToken = (HashMap)JsonUtil.json2Obj((String)accessTokenResponse, HashMap.class);
                String token = accessToken.get("access_token").toString();
                Integer expiresIn = Integer.valueOf(accessToken.get("expires_in").toString());
                return new WeChatAccessToken(token, expiresIn);
            }
            throw new CommonException(String.format("weixin url:'%s' \u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a", tokenGetUrl));
        }
        catch (Exception e) {
            throw new CommonException("\u83b7\u53d6token\u51fa\u9519\u3002", e);
        }
    }

    public static String getUnionId(String openId, String accessToken) throws CommonException {
        String unionIdGetUrl = String.format("https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s&lang=zh_CN", accessToken, openId);
        try {
            String accessTokenResponse = IOUtils.toString((URI)new URI(unionIdGetUrl));
            logger.debug("Received weixin response:'{}' from url '{}'", (Object)accessTokenResponse, (Object)unionIdGetUrl);
            if (StringUtils.isNotBlank((CharSequence)accessTokenResponse)) {
                HashMap userInfo = (HashMap)JsonUtil.json2Obj((String)accessTokenResponse, HashMap.class);
                return userInfo.get("unionid").toString();
            }
            throw new CommonException(String.format("weixin url:'%s' \u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a", unionIdGetUrl));
        }
        catch (Exception e) {
            throw new CommonException("\u83b7\u53d6user info\u51fa\u9519\u3002", e);
        }
    }

    public static String unifiedOrder() {
        return null;
    }
}

