/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.dao.redis;

import com.depotnearby.common.ro.AbstractRedisObj;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.codelogger.utils.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.Tuple;

@Repository
public class CommonRedisDao {
    private static final long CACHE_MAX_SIZE = 5000L;
    private static final Map<Class, Map<String, LoadingCache<String, Object>>> loadingCacheMap = new ConcurrentHashMap<Class, Map<String, LoadingCache<String, Object>>>();
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected ShardedJedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] hget(String key, String field) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            byte[] byArray = jedis.hget(key.getBytes(), field.getBytes());
            return byArray;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long hdel(String key, String field) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.hdel(key.getBytes(), (byte[][])new byte[][]{field.getBytes()});
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long hset(String key, String field, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            long l = jedis.hset(key.getBytes(), field.getBytes(), value);
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hsetnx(String key, String field, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            boolean bl = jedis.hsetnx(key.getBytes(), field.getBytes(), value).intValue() == 1;
            return bl;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String hmset(String key, Map<byte[], byte[]> hash) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            String string = jedis.hmset(key.getBytes(), hash);
            return string;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    protected <T extends AbstractRedisObj> String hmset(String key, T value) {
        return this.hmset(key, (T)value.toMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<byte[]> hmget(String key, byte[] ... fields) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            List list = jedis.hmget(key.getBytes(), fields);
            return list;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<byte[], byte[]> hgetAll(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Map map = jedis.hgetAll(key.getBytes());
            return map;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hexists(String key, String field) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            boolean bl = jedis.hexists(key.getBytes(), field.getBytes());
            return bl;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long sadd(String key, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.sadd(key.getBytes(), (byte[][])new byte[][]{value});
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long sadd(String key, String ... values) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.sadd(key, values);
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sismember(String key, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            boolean bl = jedis.sismember(key.getBytes(), member);
            return bl;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<byte[]> smembers(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set set = jedis.smembers(key.getBytes());
            return set;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long srem(String key, byte[] members) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.srem(key.getBytes(), (byte[][])new byte[][]{members});
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long srem(String key, String ... members) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.srem(key, members);
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long del(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.del(key.getBytes());
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            boolean bl = jedis.exists(key.getBytes());
            return bl;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean zadd(String key, double score, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long result = jedis.zadd(key.getBytes(), score, member);
            boolean bl = result == 1L || result == 0L;
            return bl;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long zrem(String key, byte[] ... members) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.zrem(key.getBytes(), members);
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long zrem(String key, String member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.zrem(key.getBytes(), (byte[][])new byte[][]{member.getBytes()});
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<byte[]> zRange(String key, long start, long end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set set = jedis.zrange(key.getBytes(), start, end);
            return set;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<byte[]> zrevrange(String key, long start, long end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set set = jedis.zrevrange(key.getBytes(), start, end);
            return set;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Tuple> zrevrangeWithScore(String key, long start, long end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set set = jedis.zrevrangeWithScores(key.getBytes(), start, end);
            return set;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<byte[]> zangeByScore(String key, String min, String max) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set set = jedis.zrangeByScore(key.getBytes(), min.getBytes(), max.getBytes());
            return set;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Tuple> zrangeWithScores(String key, long start, long end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set set = jedis.zrangeWithScores(key.getBytes(), start, end);
            return set;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long zCard(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.zcard(key.getBytes());
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Double zscore(String key, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Double d = jedis.zscore(key.getBytes(), member);
            return d;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer zscoreToInt(String key, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Double d = jedis.zscore(key.getBytes(), member);
            Integer n = d == null ? null : Integer.valueOf(d.intValue());
            return n;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long zscoreToLong(String key, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Double d = jedis.zscore(key.getBytes(), member);
            Long l = d == null ? null : Long.valueOf(d.longValue());
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long zrank(String key, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.zrank(key.getBytes(), member);
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Double zincrby(String key, double score, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Double d = jedis.zincrby(key.getBytes(), score, member);
            return d;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long rpush(String key, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.rpush(key.getBytes(), (byte[][])new byte[][]{value});
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long rpush(String key, byte[] ... strings) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.rpush(key.getBytes(), strings);
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long lpush(String key, byte[] ... strings) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.lpush(key.getBytes(), strings);
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long llen(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            long l = jedis.llen(key.getBytes());
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] lpop(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            byte[] byArray = jedis.lpop(key.getBytes());
            return byArray;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<byte[]> lrange(String key, long start, long end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            List list = jedis.lrange(key.getBytes(), start, end);
            return list;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<byte[]> zrevrangeByScore(String key, byte[] max, byte[] min) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set set = jedis.zrevrangeByScore(key.getBytes(), max, min);
            return set;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<byte[]> zrevrangeByScore(String key, String max, String min) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set set = jedis.zrevrangeByScore(key.getBytes(), max.getBytes(), min.getBytes());
            return set;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<byte[]> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set set = jedis.zrevrangeByScore(key.getBytes(), max.getBytes(), min.getBytes(), offset, count);
            return set;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long zcount(String key, String min, String max) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long count = jedis.zcount(key.getBytes(), min.getBytes(), max.getBytes());
            long l = count == null ? 0L : count;
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long zremrangeByScore(String key, String start, String end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.zremrangeByScore(key.getBytes(), start.getBytes(), end.getBytes());
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long zcount(String key, double min, double max) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.zcount(key.getBytes(), min, max);
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set set = jedis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> zrangeByScore(String key, String min, String max) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set set = jedis.zrangeByScore(key, min, max);
            return set;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> zrangeByScore(String key, long min, long max) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Set set = jedis.zrangeByScore(key, (double)min, (double)max);
            return set;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expire(String key, int seconds) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.expire(key.getBytes(), seconds);
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expireAt(String key, Long unixTime) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.expireAt(key.getBytes(), unixTime.longValue());
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List pipeHgetall(Collection<String> ids) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String id : ids) {
                jedisPipeline.hgetAll(id.getBytes());
            }
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pipeZrem(String key, Collection<String> ids) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            jedisPipeline.zrem(key, (String[])ArrayUtils.toArray(ids));
            jedisPipeline.sync();
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pipeDel(Collection<String> keys) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String key : keys) {
                jedisPipeline.del(key);
            }
            jedisPipeline.sync();
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pipeZadd(String key, double score, Collection<String> members) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String member : members) {
                jedisPipeline.zadd(key.getBytes(), score, member.getBytes());
            }
            jedisPipeline.sync();
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List pipeZcard(List<String> ids) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String id : ids) {
                jedisPipeline.zcard(id.getBytes());
            }
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pipeHmset(String key, List<Map<byte[], byte[]>> hashs) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (Map<byte[], byte[]> hash : hashs) {
                jedisPipeline.hmset(key.getBytes(), hash);
            }
            jedisPipeline.syncAndReturnAll();
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pipeHmset(Map<byte[], Map<byte[], byte[]>> hashs) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (Map.Entry<byte[], Map<byte[], byte[]>> entry : hashs.entrySet()) {
                jedisPipeline.hmset(entry.getKey(), entry.getValue());
            }
            jedisPipeline.syncAndReturnAll();
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long hincrBy(String key, byte[] field, long value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.hincrBy(key.getBytes(), field, value);
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] get(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            byte[] byArray = jedis.get(key.getBytes());
            return byArray;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getString(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            String string = jedis.get(key);
            return string;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(String key, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.set(key.getBytes(), value);
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(String key, String value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.set(key, value);
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setex(String key, int seconds, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.setex(key.getBytes(), seconds, value);
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setnx(String key, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long r = jedis.setnx(key.getBytes(), value);
            boolean bl = r != null && r.intValue() == 1;
            return bl;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getTTL(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.ttl(key.getBytes());
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long incr(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.incr(key.getBytes());
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long incrBy(String key, long value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.incrBy(key, value);
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long zrevrank(String key, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long l = jedis.zrevrank(key.getBytes(), member);
            return l;
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V loadFromCacheOrCacheLoader(String cacheLoaderKey, CacheLoader<String, V> cacheLoader, String dataKey, TimeUnit cacheTimeUnit, long cacheDuration) {
        LoadingCache loadingCache;
        Class<?> redisDaoClass = this.getClass();
        Map<String, LoadingCache<String, Object>> serviceLoadingCacheMap = loadingCacheMap.get(redisDaoClass);
        if (serviceLoadingCacheMap == null) {
            Class<?> clazz = redisDaoClass;
            synchronized (clazz) {
                serviceLoadingCacheMap = loadingCacheMap.get(redisDaoClass);
                if (serviceLoadingCacheMap == null) {
                    serviceLoadingCacheMap = new ConcurrentHashMap<String, LoadingCache<String, Object>>();
                    loadingCacheMap.put(redisDaoClass, serviceLoadingCacheMap);
                }
            }
        }
        if ((loadingCache = serviceLoadingCacheMap.get(cacheLoaderKey)) == null) {
            Class<?> clazz = redisDaoClass;
            synchronized (clazz) {
                loadingCache = serviceLoadingCacheMap.get(cacheLoaderKey);
                if (loadingCache == null) {
                    loadingCache = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterWrite(cacheDuration, cacheTimeUnit).build(cacheLoader);
                    loadingCache.put((Object)cacheLoaderKey, (Object)loadingCache);
                }
            }
        }
        try {
            return (V)loadingCache.get((Object)dataKey);
        }
        catch (CacheLoader.InvalidCacheLoadException | ExecutionException e) {
            return null;
        }
    }
}

