/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.mo.search;

import com.depotnearby.common.mo.ByteArrayMessage;
import com.depotnearby.common.util.RedisUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class LexiconMessage
implements ByteArrayMessage {
    public static final byte TYPE_MAIN_LEXICON_CHANGED = 0;
    public static final byte TYPE_FALTER_LEXICON_CHANGED = 1;
    public static final byte TYPE_SYNONYMS_LEXICON_CHANGED = 2;
    private Byte type;
    private Integer originalDataSize;
    private byte[] data;
    private Long timestamp;

    public Byte getType() {
        return this.type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Integer getOriginalDataSize() {
        return this.originalDataSize;
    }

    public void setOriginalDataSize(Integer originalDataSize) {
        this.originalDataSize = originalDataSize;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public byte[] messageEncode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(new byte[]{this.type});
            baos.write(RedisUtil.toBitByteArray((long)this.timestamp));
            baos.write(RedisUtil.toBitByteArray((int)this.originalDataSize));
            baos.write(this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public void messageDecode(byte[] encodedData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedData);
        try {
            byte[] bypeBytes = new byte[1];
            int readSize = bais.read(bypeBytes);
            if (readSize < bypeBytes.length) {
                return;
            }
            this.type = bypeBytes[0];
            byte[] tsBytes = new byte[8];
            readSize = bais.read(tsBytes);
            if (readSize < tsBytes.length) {
                return;
            }
            this.timestamp = RedisUtil.bitByteArrayToLong((byte[])tsBytes);
            byte[] originalDataSizeBytes = new byte[4];
            readSize = bais.read(originalDataSizeBytes);
            if (readSize < originalDataSizeBytes.length) {
                return;
            }
            this.originalDataSize = RedisUtil.bitByteArrayToInt((byte[])originalDataSizeBytes);
            this.data = new byte[bais.available()];
            bais.read(this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

