/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.mo.search;

import com.depotnearby.common.mo.ByteArrayMessage;
import com.depotnearby.common.util.RedisUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SensitiveWordMessage
implements ByteArrayMessage {
    private Integer originalDataSize;
    private byte[] data;
    private Long timestamp;

    public Integer getOriginalDataSize() {
        return this.originalDataSize;
    }

    public void setOriginalDataSize(Integer originalDataSize) {
        this.originalDataSize = originalDataSize;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public byte[] messageEncode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(RedisUtil.toBitByteArray((long)this.timestamp));
            baos.write(RedisUtil.toBitByteArray((int)this.originalDataSize));
            baos.write(this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public void messageDecode(byte[] encodedData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedData);
        try {
            byte[] tsBytes = new byte[8];
            int readSize = bais.read(tsBytes);
            if (readSize < tsBytes.length) {
                return;
            }
            this.timestamp = RedisUtil.bitByteArrayToLong((byte[])tsBytes);
            byte[] originalDataSizeBytes = new byte[4];
            readSize = bais.read(originalDataSizeBytes);
            if (readSize < originalDataSizeBytes.length) {
                return;
            }
            this.originalDataSize = RedisUtil.bitByteArrayToInt((byte[])originalDataSizeBytes);
            this.data = new byte[bais.available()];
            bais.read(this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

