/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.admin;

import com.depotnearby.common.po.CommonStatus;
import com.depotnearby.common.po.admin.AdminAuthority;
import com.depotnearby.common.po.admin.AdminLevel;
import com.depotnearby.common.po.admin.Menu;
import com.depotnearby.common.po.admin.MenuItem;
import com.depotnearby.common.po.admin.Resource;
import com.depotnearby.common.po.admin.Role;
import com.depotnearby.common.po.depot.DepotPo;
import com.depotnearby.common.po.geo.CityPo;
import com.depotnearby.common.po.organization.CompanyPo;
import com.depotnearby.common.vo.admin.MenuGroupVo;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;
import org.codelogger.utils.CollectionUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@Table(name="adm_admin")
public class Admin
implements Serializable,
UserDetails {
    public static final boolean ENABLED = true;
    public static final boolean DISABLED = false;
    @Id
    @Column(length=40, nullable=false)
    private String username;
    @Column(nullable=false)
    private boolean enabled = true;
    @Column(length=40, name="pwd", nullable=false)
    private String password;
    @Column(length=40, nullable=false)
    private String name;
    @Column(length=50)
    private String email;
    @Column(length=20)
    private String mobile;
    @Column(length=255)
    private String permitIP;
    @Column(length=50)
    private String msn;
    @Column(length=20)
    private String qq;
    @Column(nullable=false)
    private Date createDate;
    @Column(length=40, nullable=false)
    private String createBy;
    @Column(nullable=true)
    private String channelId;
    @Column
    private String inviterCode;
    @ManyToMany(cascade={CascadeType.PERSIST}, fetch=FetchType.LAZY)
    @JoinTable(name="adm_admin_role", joinColumns={@JoinColumn(name="admin_username", referencedColumnName="username")}, inverseJoinColumns={@JoinColumn(name="role_id", referencedColumnName="id")}, uniqueConstraints={@UniqueConstraint(columnNames={"admin_username", "role_id"})})
    private List<Role> roles;
    @Transient
    private Timestamp lastActiveTime;
    @Transient
    private String loginIP;
    @Transient
    private String lastRequest;
    @Transient
    private String menuJSStr;
    @Transient
    private String permissionPath;
    @Transient
    private List<Menu> menus;
    @Transient
    private List<MenuGroupVo> menuGroups;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="org_company_admin", joinColumns={@JoinColumn(name="admin_id", referencedColumnName="username")}, inverseJoinColumns={@JoinColumn(name="company_id", referencedColumnName="id")}, uniqueConstraints={@UniqueConstraint(columnNames={"admin_id", "company_id"})})
    private Set<CompanyPo> companies;
    @Column(columnDefinition="TINYINT")
    @Convert(converter=AdminLevel.Converter.class)
    private AdminLevel adminLevel;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="adm_admin_depot", joinColumns={@JoinColumn(name="admin_id", referencedColumnName="username")}, inverseJoinColumns={@JoinColumn(name="depot_id", referencedColumnName="id")}, uniqueConstraints={@UniqueConstraint(columnNames={"admin_id", "depot_id"})})
    private Set<DepotPo> depots;

    public String getNameOrUserName() {
        return StringUtils.isBlank((CharSequence)this.name) ? this.username : this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getPermitIP() {
        return this.permitIP;
    }

    public Timestamp getLastActiveTime() {
        return this.lastActiveTime;
    }

    public String getLoginIP() {
        return this.loginIP;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setPermitIP(String permitIP) {
        this.permitIP = permitIP;
    }

    public void setLastActiveTime(Timestamp lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    public void setLoginIP(String loginIP) {
        this.loginIP = loginIP;
    }

    public String getMsn() {
        return this.msn;
    }

    public void setMsn(String msn) {
        this.msn = msn;
    }

    public void setLastRequest(String lastRequest) {
        this.lastRequest = lastRequest;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public void setMenuJSStr(String menuJSStr) {
        this.menuJSStr = menuJSStr;
    }

    public String getPermissionPath() {
        return this.permissionPath;
    }

    public String getLastRequest() {
        return this.lastRequest;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public String getUsername() {
        return this.username;
    }

    public String getQq() {
        return this.qq;
    }

    public String getMenuJSStr() {
        return this.menuJSStr;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getInviterCode() {
        return this.inviterCode;
    }

    public void setInviterCode(String inviterCode) {
        this.inviterCode = inviterCode;
    }

    public Set<CompanyPo> getCompanies() {
        return this.companies;
    }

    public void setCompanies(Set<CompanyPo> companies) {
        this.companies = companies;
    }

    public Set<Integer> getCityIdsOfNormalCompanies() {
        HashSet cityIds = Sets.newHashSet();
        Set<CompanyPo> companies = this.getCompanies();
        if (CollectionUtils.isNotEmpty(companies)) {
            for (CompanyPo company : companies) {
                List<CityPo> cities;
                if (company.getStatus() != CommonStatus.ENABLE || !CollectionUtils.isNotEmpty(cities = company.getCities())) continue;
                for (CityPo city : cities) {
                    cityIds.add(city.getId());
                }
            }
        }
        return cityIds;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        HashSet<GrantedAuthority> auths = new HashSet<GrantedAuthority>();
        if (this.roles != null) {
            for (Role role : this.roles) {
                List<MenuItem> menuItems = role.getMenuItems();
                for (MenuItem menuItem : menuItems) {
                    String[] roleSymbol;
                    if (!StringUtils.isNotBlank((CharSequence)menuItem.getSymbol())) continue;
                    for (String sybmol : roleSymbol = menuItem.getSymbol().split("[^\\w_]+")) {
                        auths.add(new AdminAuthority(sybmol));
                    }
                }
                List<Resource> resources = role.getResources();
                for (Resource resource : resources) {
                    String[] roleSymbol;
                    if (!StringUtils.isNotBlank((CharSequence)resource.getSymbol())) continue;
                    for (String sybmol : roleSymbol = resource.getSymbol().split("[^\\w_]+")) {
                        auths.add(new AdminAuthority(sybmol));
                    }
                }
            }
            System.out.println(" auth size:" + auths.size());
        }
        return auths;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public List<Menu> getMenus() {
        return this.menus;
    }

    public void setMenus(List<Menu> menus) {
        this.menus = menus;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void copy(Admin admin) {
        this.enabled = admin.enabled;
        this.name = admin.name;
        this.email = admin.email;
        this.mobile = admin.mobile;
        this.permitIP = admin.permitIP;
        this.msn = admin.msn;
        this.qq = admin.qq;
        this.channelId = admin.channelId;
        this.inviterCode = admin.inviterCode;
    }

    public AdminLevel getAdminLevel() {
        return this.adminLevel;
    }

    public void setAdminLevel(AdminLevel adminLevel) {
        this.adminLevel = adminLevel;
    }

    public Set<DepotPo> getDepots() {
        return this.depots;
    }

    public void setDepots(Set<DepotPo> depots) {
        this.depots = depots;
    }

    public void setMenuGroups(List<MenuGroupVo> menuGroups) {
        this.menuGroups = menuGroups;
    }

    public List<MenuGroupVo> getMenuGroups() {
        return this.menuGroups;
    }
}

