/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.admin;

import com.depotnearby.common.po.admin.MainMenu;
import com.depotnearby.common.po.admin.Resource;
import com.depotnearby.common.po.admin.Role;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="adm_menuitem")
public class MenuItem
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Column(nullable=true)
    private Integer code;
    @Column(length=50, nullable=false)
    private String name;
    @Column(length=200)
    private String link;
    @Column(length=255)
    private String description;
    @Column(length=255)
    private String symbol;
    @ManyToOne
    private MainMenu mainMenu;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="menuItem")
    private List<Resource> resources;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="adm_role_menuitem", joinColumns={@JoinColumn(name="menuitem_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="role_id", referencedColumnName="id")}, uniqueConstraints={@UniqueConstraint(columnNames={"menuitem_id", "role_id"})})
    private List<Role> roles;

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLink() {
        return this.link;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public Long getId() {
        return this.id;
    }

    public void setMainMenu(MainMenu mainMenu) {
        this.mainMenu = mainMenu;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String toString() {
        return this.name;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public void copy(MenuItem item) {
        this.code = item.code;
        this.name = item.name;
        this.link = item.link;
        this.description = item.description;
        this.symbol = item.symbol;
    }
}

