/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.admin;

import com.depotnearby.common.po.admin.Admin;
import com.depotnearby.common.po.admin.MenuItem;
import com.depotnearby.common.po.admin.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="adm_role")
public class Role
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Column(length=50, nullable=false)
    private String name;
    @Column(length=255)
    private String description;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="adm_role_menuitem", joinColumns={@JoinColumn(name="role_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="menuitem_id", referencedColumnName="id")}, uniqueConstraints={@UniqueConstraint(columnNames={"role_id", "menuitem_id"})})
    private List<MenuItem> menuItems;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="adm_role_resource", joinColumns={@JoinColumn(name="role_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="resource_id", referencedColumnName="id")}, uniqueConstraints={@UniqueConstraint(columnNames={"role_id", "resource_id"})})
    private List<Resource> resources;
    @ManyToMany(mappedBy="roles")
    private List<Admin> admins;

    public List<Admin> getAdmins() {
        return this.admins;
    }

    public void setAdmins(List<Admin> admins) {
        this.admins = admins;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addMenuItem(MenuItem menuItem) {
        if (this.menuItems == null) {
            this.menuItems = new ArrayList<MenuItem>();
        }
        if (!this.menuItems.contains(menuItem)) {
            this.menuItems.add(menuItem);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<MenuItem> getMenuItems() {
        return this.menuItems;
    }

    public Long getId() {
        return this.id;
    }

    public void setMenuItems(List<MenuItem> menuItems) {
        this.menuItems = menuItems;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String toString() {
        return this.getName();
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }
}

