/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.depot;

import com.depotnearby.common.po.CommonAuditStatus;
import com.depotnearby.common.po.CommonStatus;
import com.depotnearby.common.po.Persistent;
import com.depotnearby.common.po.admin.Admin;
import com.depotnearby.common.po.depot.DepotEmployeePo;
import com.depotnearby.common.po.depot.DepotType;
import com.depotnearby.common.po.depot.WarehousePo;
import com.depotnearby.common.po.geo.CityPo;
import com.depotnearby.common.po.geo.DistrictPo;
import com.depotnearby.common.po.geo.ProvincePo;
import com.depotnearby.common.po.organization.CompanyPo;
import com.depotnearby.common.po.product.DepotProductPo;
import com.depotnearby.common.po.shop.ShopPo;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="depot")
public class DepotPo
implements Persistent {
    @Id
    @Column(length=40, nullable=false)
    private String id;
    @Column(length=50, unique=true)
    private String mcuCode;
    @Column(length=50, nullable=false)
    private String name;
    @Column(length=300, nullable=false)
    private String address;
    @Column(columnDefinition="DECIMAL(9,6)")
    private BigDecimal depotLongitude;
    @Column(columnDefinition="DECIMAL(9,6)")
    private BigDecimal depotLatitude;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="provinceId")
    private ProvincePo province;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="cityId")
    private CityPo city;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="districtId")
    private DistrictPo district;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="companyId")
    private CompanyPo company;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="warehouseId")
    private WarehousePo warehouse;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="depot")
    private List<DepotEmployeePo> employees;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="depot")
    private List<DepotProductPo> depotProducts;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="depot")
    private List<ShopPo> shops;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="adm_admin_depot", joinColumns={@JoinColumn(name="depot_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="admin_id", referencedColumnName="username")}, uniqueConstraints={@UniqueConstraint(columnNames={"depot_id", "admin_id"})})
    private List<Admin> admins;
    @Column(columnDefinition="TINYINT")
    @Convert(converter=DepotType.Converter.class)
    private DepotType depotType;
    @Column(columnDefinition="TINYINT", nullable=false)
    @Convert(converter=CommonAuditStatus.CommonAuditStatusConverter.class)
    private CommonAuditStatus auditStatus;
    @Column(columnDefinition="TINYINT", nullable=false)
    @Convert(converter=CommonStatus.CommonStatusConverter.class)
    private CommonStatus enableStatus = CommonStatus.ENABLE;
    @Column(length=10)
    private String areaNo;
    @Column
    private String qrcode;

    public DepotPo() {
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public DepotPo(String id) {
        this.id = id;
    }

    public String getMcuCode() {
        return this.mcuCode;
    }

    public void setMcuCode(String mcuCode) {
        this.mcuCode = mcuCode;
    }

    public ProvincePo getProvince() {
        return this.province;
    }

    public void setProvince(ProvincePo province) {
        this.province = province;
    }

    public CityPo getCity() {
        return this.city;
    }

    public void setCity(CityPo city) {
        this.city = city;
    }

    public DistrictPo getDistrict() {
        return this.district;
    }

    public void setDistrict(DistrictPo district) {
        this.district = district;
    }

    public BigDecimal getDepotLongitude() {
        return this.depotLongitude;
    }

    public void setDepotLongitude(BigDecimal depotLongitude) {
        this.depotLongitude = depotLongitude;
    }

    public BigDecimal getDepotLatitude() {
        return this.depotLatitude;
    }

    public void setDepotLatitude(BigDecimal depotLatitude) {
        this.depotLatitude = depotLatitude;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<DepotEmployeePo> getEmployees() {
        return this.employees;
    }

    public void setEmployees(List<DepotEmployeePo> employees) {
        this.employees = employees;
    }

    public List<DepotProductPo> getDepotProducts() {
        return this.depotProducts;
    }

    public void setDepotProducts(List<DepotProductPo> depotProducts) {
        this.depotProducts = depotProducts;
    }

    public List<ShopPo> getShops() {
        return this.shops;
    }

    public void setShops(List<ShopPo> shops) {
        this.shops = shops;
    }

    public List<Admin> getAdmins() {
        return this.admins;
    }

    public void setAdmins(List<Admin> admins) {
        this.admins = admins;
    }

    public DepotType getDepotType() {
        return this.depotType;
    }

    public void setDepotType(DepotType depotType) {
        this.depotType = depotType;
    }

    public CommonAuditStatus getAuditStatus() {
        return this.auditStatus;
    }

    public void setAuditStatus(CommonAuditStatus auditStatus) {
        this.auditStatus = auditStatus;
    }

    public CommonStatus getEnableStatus() {
        return this.enableStatus;
    }

    public void setEnableStatus(CommonStatus enableStatus) {
        this.enableStatus = enableStatus;
    }

    public String getAreaNo() {
        return this.areaNo;
    }

    public void setAreaNo(String zclass) {
        this.areaNo = zclass;
    }

    public CompanyPo getCompany() {
        return this.company;
    }

    public void setCompany(CompanyPo company) {
        this.company = company;
    }

    public WarehousePo getWarehouse() {
        return this.warehouse;
    }

    public void setWarehouse(WarehousePo warehouse) {
        this.warehouse = warehouse;
    }

    public String getQrcode() {
        return this.qrcode;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }
}

