/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.geo;

import com.depotnearby.common.po.Persistent;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.apache.commons.lang3.StringUtils;

@MappedSuperclass
public class AbstractAreaWithCode
implements Persistent {
    @Id
    private Integer id;
    @JsonIgnore
    @Column(length=50, nullable=false)
    protected String code;
    @Column(length=50)
    protected String name;
    @JsonIgnore
    @Column
    protected Integer idx;
    @JsonIgnore
    @Column
    protected Integer weight = 1;
    @JsonIgnore
    @Column(columnDefinition="MEDIUMTEXT")
    protected String coordinate;
    @JsonIgnore
    @Column(columnDefinition="decimal(9,6)")
    protected BigDecimal lat;
    @JsonIgnore
    @Column(columnDefinition="decimal(9,6)")
    protected BigDecimal lon;
    @JsonIgnore
    @Column(length=50)
    protected String baiduname;
    @JsonIgnore
    @Column(length=255)
    protected String description;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getIdx() {
        return this.idx;
    }

    public void setIdx(Integer idx) {
        this.idx = idx;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public String getCoordinate() {
        return this.coordinate;
    }

    public void setCoordinate(String coordinate) {
        this.coordinate = coordinate;
    }

    public BigDecimal getLat() {
        return this.lat;
    }

    public void setLat(BigDecimal lat) {
        this.lat = lat;
    }

    public BigDecimal getLon() {
        return this.lon;
    }

    public void setLon(BigDecimal lon) {
        this.lon = lon;
    }

    public String getBaiduname() {
        return this.baiduname;
    }

    public void setBaiduname(String baiduname) {
        this.baiduname = baiduname;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public double[] getOutBox() {
        if (StringUtils.isNotBlank((CharSequence)this.coordinate)) {
            double[] result = new double[]{180.0, -180.0, 90.0, -90.0};
            try {
                String[] arr;
                for (String s : arr = this.coordinate.split("\\|")) {
                    String[] parr;
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    for (String p : parr = s.split(";")) {
                        int idx = p.indexOf(44);
                        double lon = Double.valueOf(p.substring(0, idx).trim());
                        double lat = Double.valueOf(p.substring(idx + 1).trim());
                        result[0] = Math.min(result[0], lon);
                        result[1] = Math.max(result[1], lon);
                        result[2] = Math.min(result[2], lat);
                        result[3] = Math.max(result[3], lat);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
        return null;
    }
}

