/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.geo;

import com.depotnearby.common.model.geo.IBusiness;
import com.depotnearby.common.po.geo.AbstractAreaWithCode;
import com.depotnearby.common.po.geo.CityPo;
import com.depotnearby.common.po.geo.DistrictPo;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="geo_business")
public class BusinessPo
extends AbstractAreaWithCode
implements IBusiness {
    private Integer status;
    @ManyToOne(optional=true)
    @JoinColumn(name="districtId")
    private DistrictPo district;
    @ManyToOne(optional=true)
    @JoinColumn(name="cityId")
    private CityPo city;

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public DistrictPo getDistrict() {
        return this.district;
    }

    public void setDistrict(DistrictPo district) {
        this.district = district;
    }

    public CityPo getCity() {
        return this.city;
    }

    public void setCity(CityPo city) {
        this.city = city;
    }

    public Integer getParentId() {
        if (this.district != null) {
            return this.district.getId();
        }
        return null;
    }

    public int getLevel() {
        return 5;
    }

    public DistrictPo getParent() {
        return this.district;
    }

    public List getChildren() {
        return null;
    }

    @Override
    public double[] getOutBox() {
        if (StringUtils.isNotBlank((CharSequence)this.coordinate)) {
            double[] result = new double[]{180.0, -180.0, 90.0, -90.0};
            try {
                String[] arr;
                for (String s : arr = this.coordinate.split("\\|")) {
                    String[] parr;
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    for (String p : parr = s.split(";")) {
                        int idx = p.indexOf(44);
                        double lon = Double.valueOf(p.substring(0, idx).trim());
                        double lat = Double.valueOf(p.substring(idx + 1).trim());
                        result[0] = Math.min(result[0], lon);
                        result[1] = Math.max(result[1], lon);
                        result[2] = Math.min(result[2], lat);
                        result[3] = Math.max(result[3], lat);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
        return null;
    }
}

