/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.geo;

import com.depotnearby.common.model.geo.ICity;
import com.depotnearby.common.po.geo.AbstractAreaWithCode;
import com.depotnearby.common.po.geo.DistrictPo;
import com.depotnearby.common.po.geo.ProvincePo;
import com.depotnearby.common.po.organization.CompanyPo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="geo_city")
public class CityPo
extends AbstractAreaWithCode
implements ICity {
    private Integer status;
    @JsonIgnore
    @ManyToOne(optional=true)
    @JoinColumn(name="provinceId")
    private ProvincePo province;
    @OneToMany(mappedBy="city", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy(value="idx")
    @NotFound(action=NotFoundAction.IGNORE)
    private List<DistrictPo> districts;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="org_company_city", joinColumns={@JoinColumn(name="city_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="company_id", referencedColumnName="id")}, uniqueConstraints={@UniqueConstraint(columnNames={"city_id", "company_id"})})
    private Set<CompanyPo> companies;

    public ProvincePo getProvince() {
        return this.province;
    }

    public void setProvince(ProvincePo province) {
        this.province = province;
    }

    public List<DistrictPo> getDistricts() {
        return this.districts;
    }

    public void setDistricts(List<DistrictPo> districts) {
        this.districts = districts;
    }

    @JsonIgnore
    public Integer getParentId() {
        if (this.province != null) {
            return this.province.getId();
        }
        return null;
    }

    public int getLevel() {
        return 3;
    }

    @JsonIgnore
    public ProvincePo getParent() {
        return this.province;
    }

    @JsonIgnore
    public List getChildren() {
        return this.districts;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Set<CompanyPo> getCompanies() {
        return this.companies;
    }

    public void setCompanies(Set<CompanyPo> companies) {
        this.companies = companies;
    }
}

