/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.geo;

import com.depotnearby.common.model.geo.IDistrict;
import com.depotnearby.common.po.geo.AbstractAreaWithCode;
import com.depotnearby.common.po.geo.BusinessPo;
import com.depotnearby.common.po.geo.CityPo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="geo_district")
public class DistrictPo
extends AbstractAreaWithCode
implements IDistrict {
    private Integer status;
    @JsonIgnore
    @ManyToOne(optional=true)
    @JoinColumn(name="cityId")
    private CityPo city;
    @JsonIgnore
    @OneToMany(mappedBy="district", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy(value="idx")
    @NotFound(action=NotFoundAction.IGNORE)
    private List<BusinessPo> businesses;

    public CityPo getCity() {
        return this.city;
    }

    public void setCity(CityPo city) {
        this.city = city;
    }

    public List<BusinessPo> getBusinesses() {
        return this.businesses;
    }

    public void setBusinesses(List<BusinessPo> businesses) {
        this.businesses = businesses;
    }

    @JsonIgnore
    public Integer getParentId() {
        if (this.city != null) {
            return this.city.getId();
        }
        return null;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public int getLevel() {
        return 4;
    }

    @JsonIgnore
    public CityPo getParent() {
        return this.city;
    }

    @JsonIgnore
    public List getChildren() {
        return this.businesses;
    }
}

