/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.log;

import com.depotnearby.common.po.Persistent;
import com.depotnearby.common.ro.log.LogRo;
import com.depotnearby.util.DateTool;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.codelogger.utils.ValueUtils;

@Entity
@Table(name="manage_log")
public class LogPo
implements Persistent {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Column(length=255, nullable=false)
    private String uri;
    @Column(length=10, nullable=false)
    private String http_method;
    @JsonIgnore
    @Column(columnDefinition="MEDIUMTEXT")
    private String requestParams;
    @Column(length=50, nullable=false)
    private String user;
    @Column(length=50, nullable=false)
    private Timestamp timestamp;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getHttp_method() {
        return this.http_method;
    }

    public void setHttp_method(String http_method) {
        this.http_method = http_method;
    }

    public String getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(String requestParams) {
        this.requestParams = requestParams;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public LogPo fromRo(LogRo ro) {
        this.id = ro.getId();
        this.uri = ro.getUri();
        this.timestamp = ValueUtils.getValue((Long)ro.getTimeStamp()) > 0L ? new Timestamp(ro.getTimeStamp()) : DateTool.nowTimestamp();
        this.http_method = ro.getHttp_method();
        this.requestParams = ro.getRequestParams();
        this.user = ro.getUser();
        return this;
    }
}

