/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.order;

import com.depotnearby.common.model.order.ICreateOrderItemVo;
import com.depotnearby.common.po.Persistent;
import com.depotnearby.common.po.order.OrderPo;
import com.depotnearby.common.vo.order.CreateOrderItemVo;
import com.depotnearby.vo.statistic.ProductSalesStatisticResultVo;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.ConstructorResult;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Table;

@SqlResultSetMapping(name="ProductSalesStatisticBinding", classes={@ConstructorResult(targetClass=ProductSalesStatisticResultVo.class, columns={@ColumnResult(name="province_name"), @ColumnResult(name="shop_type_name"), @ColumnResult(name="product_category"), @ColumnResult(name="product_name"), @ColumnResult(name="avg_price"), @ColumnResult(name="total_quantity"), @ColumnResult(name="total_amount")})})
@Entity
@Table(name="order_item")
public class OrderItemPo
implements Persistent,
ICreateOrderItemVo {
    @Id
    protected Long id;
    @ManyToOne(cascade={CascadeType.ALL}, optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="orderId")
    protected OrderPo orderPo;
    @Column(nullable=false)
    protected Long productId;
    @Column(length=50)
    private String centerId;
    @Column(nullable=false)
    protected Integer quantity;
    @Column(nullable=false)
    protected int price;
    @Column(length=255)
    protected String name;
    @Column(length=255)
    protected String productLogo;
    @Column(nullable=false)
    private Integer depotPrice;
    @Column(nullable=false)
    private Integer costPrice;

    public OrderItemPo() {
    }

    public OrderItemPo(CreateOrderItemVo c) {
        this.productId = c.getProductId();
        this.centerId = c.getCenterId();
        this.name = c.getName();
        this.price = c.getPrice();
        this.depotPrice = c.getDepotPrice();
        this.costPrice = c.getCostPrice();
        this.quantity = c.getQuantity();
        this.productLogo = c.getProductLogo();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public OrderPo getOrderPo() {
        return this.orderPo;
    }

    public void setOrderPo(OrderPo orderPo) {
        this.orderPo = orderPo;
    }

    public Long getProductId() {
        return this.productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getCenterId() {
        return this.centerId;
    }

    public void setCenterId(String centerId) {
        this.centerId = centerId;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int price) {
        this.price = price;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProductLogo() {
        return this.productLogo;
    }

    public void setProductLogo(String productLogo) {
        this.productLogo = productLogo;
    }

    public int getLineTotal() {
        return this.price * this.quantity;
    }

    public Integer getDepotPrice() {
        return this.depotPrice;
    }

    public void setDepotPrice(Integer depotPrice) {
        this.depotPrice = depotPrice;
    }

    public Integer getCostPrice() {
        return this.costPrice;
    }

    public void setCostPrice(Integer costPrice) {
        this.costPrice = costPrice;
    }
}

