/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.order;

import com.depotnearby.common.model.IOrder;
import com.depotnearby.common.model.ObjWithLongId;
import com.depotnearby.common.po.Persistent;
import com.depotnearby.common.po.depot.DepotPo;
import com.depotnearby.common.po.distribution.RebateDetailPo;
import com.depotnearby.common.po.order.DeliveryOrderPo;
import com.depotnearby.common.po.order.OrderConsigneePo;
import com.depotnearby.common.po.order.OrderItemPo;
import com.depotnearby.common.po.order.OrderLogisticsPo;
import com.depotnearby.common.po.order.OrderPaymentPo;
import com.depotnearby.common.po.order.OrderRefundItemPo;
import com.depotnearby.common.po.order.OrderSalePromotionItemPo;
import com.depotnearby.common.po.order.OrderSource;
import com.depotnearby.common.po.order.OrderTicketPo;
import com.depotnearby.common.po.order.OrderVoucherPo;
import com.depotnearby.common.vo.order.BackMoneyBillVo;
import com.depotnearby.common.vo.order.OrderItemVo;
import com.depotnearby.common.vo.order.OrderVo;
import com.depotnearby.vo.statistic.DailyStatRecordResultVo;
import com.depotnearby.vo.statistic.DepotShopOrderStatisticResultVo;
import com.depotnearby.vo.statistic.InviteStatisticResultVo;
import com.depotnearby.vo.statistic.OrderPaymentStatisticResultVo;
import com.depotnearby.vo.statistic.OrderVoucherStatisticResultVo;
import com.depotnearby.vo.statistic.UserRecommendOrderedStatisticResultVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.ConstructorResult;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.codelogger.utils.CollectionUtils;
import org.codelogger.utils.DateUtils;

@SqlResultSetMappings(value={@SqlResultSetMapping(name="OrderPaymentStatisticBinding", classes={@ConstructorResult(targetClass=OrderPaymentStatisticResultVo.class, columns={@ColumnResult(name="id"), @ColumnResult(name="paidtime"), @ColumnResult(name="tradeno"), @ColumnResult(name="createtime"), @ColumnResult(name="ordercode"), @ColumnResult(name="payamount"), @ColumnResult(name="paymenttype")})}), @SqlResultSetMapping(name="InviterStatisticBinding", classes={@ConstructorResult(targetClass=InviteStatisticResultVo.class, columns={@ColumnResult(name="invite_code"), @ColumnResult(name="invite_name"), @ColumnResult(name="shop_type_name"), @ColumnResult(name="shop_count"), @ColumnResult(name="order_amount"), @ColumnResult(name="pay_amount"), @ColumnResult(name="offset_amount")})}), @SqlResultSetMapping(name="DailyStatRecordBinding", classes={@ConstructorResult(targetClass=DailyStatRecordResultVo.class, columns={@ColumnResult(name="d_day"), @ColumnResult(name="province_id"), @ColumnResult(name="shop_type_id"), @ColumnResult(name="order_amount"), @ColumnResult(name="order_count")})}), @SqlResultSetMapping(name="OrderVoucherRecordBinding", classes={@ConstructorResult(targetClass=OrderVoucherStatisticResultVo.class, columns={@ColumnResult(name="time"), @ColumnResult(name="order_code"), @ColumnResult(name="user_mobile"), @ColumnResult(name="province_name"), @ColumnResult(name="shop_type_name"), @ColumnResult(name="voucher_type_name"), @ColumnResult(name="order_amount"), @ColumnResult(name="voucher_offset_amount"), @ColumnResult(name="order_pay_amount")})}), @SqlResultSetMapping(name="DepotShopOrderStatisticBinding", classes={@ConstructorResult(targetClass=DepotShopOrderStatisticResultVo.class, columns={@ColumnResult(name="province_id"), @ColumnResult(name="province_name"), @ColumnResult(name="depot_name"), @ColumnResult(name="order_shop_count"), @ColumnResult(name="order_amount"), @ColumnResult(name="pay_amount"), @ColumnResult(name="offset_amount")})}), @SqlResultSetMapping(name="UserRecommendOrderedStatisticBinding", classes={@ConstructorResult(targetClass=UserRecommendOrderedStatisticResultVo.class, columns={@ColumnResult(name="mobile"), @ColumnResult(name="shop_type_name"), @ColumnResult(name="product_name"), @ColumnResult(name="category_name"), @ColumnResult(name="product_quantity"), @ColumnResult(name="total_amount"), @ColumnResult(name="avg_price")})}), @SqlResultSetMapping(name="OrderVo", classes={@ConstructorResult(targetClass=OrderVo.class, columns={@ColumnResult(name="id", type=BigInteger.class), @ColumnResult(name="orderCode", type=String.class), @ColumnResult(name="payAmount", type=BigDecimal.class)})}), @SqlResultSetMapping(name="OrderItemVo", classes={@ConstructorResult(targetClass=OrderItemVo.class, columns={@ColumnResult(name="productlogo", type=String.class), @ColumnResult(name="name", type=String.class), @ColumnResult(name="quantity", type=Integer.class)})}), @SqlResultSetMapping(name="BackMoneyVo", classes={@ConstructorResult(targetClass=BackMoneyBillVo.class, columns={@ColumnResult(name="orderId", type=BigInteger.class), @ColumnResult(name="refundId", type=Long.class), @ColumnResult(name="orderCode", type=String.class), @ColumnResult(name="refundType", type=Integer.class), @ColumnResult(name="refundReason", type=String.class), @ColumnResult(name="refundApplyTime", type=String.class), @ColumnResult(name="refundOperator", type=String.class), @ColumnResult(name="refundOperateTime", type=String.class), @ColumnResult(name="backAmt", type=Integer.class), @ColumnResult(name="backAmtStatus", type=Integer.class)})})})
@Entity
@Table(name="order_detail")
public class OrderPo
implements Persistent,
IOrder,
ObjWithLongId,
Comparable<OrderPo> {
    @Id
    protected Long id;
    @Column
    private Long oldId;
    @Column(length=50, nullable=true)
    protected String orderCode;
    @Column(nullable=false)
    protected Long buyerId;
    @Column
    protected Integer channelId;
    @Column(nullable=false)
    protected Long shopId;
    @Column(nullable=false)
    protected Timestamp createTime;
    @Column(nullable=true)
    protected Timestamp payLimitTime;
    @Column
    protected Timestamp acceptTime;
    @Column
    protected Timestamp finishTime;
    @Column(nullable=false)
    protected Integer status = 10;
    @Column(columnDefinition="int DEFAULT 0", nullable=false)
    protected Integer refundStatus = 0;
    @Column
    protected String statusDesc;
    @Column
    protected String statusMsg;
    @Column(nullable=false)
    protected Integer payStatus = 1;
    @Column(nullable=true)
    protected Integer paymentType = IOrder.PaymentType.PAY_ONLINE;
    @Column(length=255)
    protected String description;
    @Column(length=255)
    protected String sellerNote;
    @Column(nullable=false)
    protected Integer orderAmount = 0;
    @Column(nullable=false)
    protected Integer freeAmount = 0;
    @Column(nullable=false)
    protected Integer voucherOffsetAmount = 0;
    @Column(nullable=false)
    protected Integer payAmount = 0;
    @Column(length=255)
    protected String rejectReason;
    @Column(length=200, nullable=true)
    protected String subject;
    @Column(length=250, nullable=true)
    protected String detail;
    @Column(length=50, nullable=true)
    protected String acceptAdmin;
    @Column(name="version", columnDefinition="int DEFAULT 0", nullable=false)
    private long version = 0L;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, optional=true)
    protected OrderTicketPo ticket;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, optional=false)
    protected OrderConsigneePo consignee;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="orderPo")
    protected List<RebateDetailPo> rebateDetailPos;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="orderPo")
    protected List<DeliveryOrderPo> deliveryOrderPos;
    @OneToMany(mappedBy="orderPo", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy(value="id asc")
    protected List<OrderItemPo> items;
    @OneToMany(mappedBy="orderPo", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    protected List<OrderSalePromotionItemPo> promotionItems;
    @OneToMany(mappedBy="orderPo", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy(value="id asc")
    protected List<OrderVoucherPo> vouchers;
    @OneToMany(mappedBy="orderPo", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy(value="id asc")
    protected List<OrderPaymentPo> payments;
    @OneToMany(mappedBy="orderPo", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy(value="id asc")
    protected List<OrderLogisticsPo> logisticses;
    @OneToMany(mappedBy="orderPo", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @OrderBy(value="id asc")
    protected List<OrderRefundItemPo> orderRefundItems;
    @ManyToOne(optional=true)
    @JoinColumn(name="deliveryDepotId")
    protected DepotPo deliveryDepot;
    @ManyToOne(optional=false)
    @JoinColumn(name="priceDepotId")
    protected DepotPo priceDepot;
    @Column(columnDefinition="int DEFAULT 0", nullable=false)
    protected Integer type = 0;
    @Column(unique=true)
    protected Long nuomiId;
    @Column
    protected Long nuomiBuyerId;
    @Column(length=50)
    protected String channelUserId;
    @Column
    protected Integer nuomiStatus;
    @Column
    @Convert(converter=OrderSource.Converter.class)
    protected OrderSource source = OrderSource.APP_NORMAL;
    @Column
    protected Integer deliveryStatus = 0;
    @Column
    protected BigDecimal advancePayAmount = BigDecimal.valueOf(0L);

    public BigDecimal getAdvancePayAmount() {
        return this.advancePayAmount;
    }

    public void setAdvancePayAmount(BigDecimal advancePayAmount) {
        this.advancePayAmount = advancePayAmount;
    }

    public String getSellerNote() {
        return this.sellerNote;
    }

    public void setSellerNote(String sellerNote) {
        this.sellerNote = sellerNote;
    }

    public Integer getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public void setDeliveryStatus(Integer deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public List<DeliveryOrderPo> getDeliveryOrderPos() {
        return this.deliveryOrderPos;
    }

    public void setDeliveryOrderPos(List<DeliveryOrderPo> deliveryOrderPos) {
        this.deliveryOrderPos = deliveryOrderPos;
    }

    public List<RebateDetailPo> getRebateDetailPos() {
        return this.rebateDetailPos;
    }

    public void setRebateDetailPos(List<RebateDetailPo> rebateDetailPos) {
        this.rebateDetailPos = rebateDetailPos;
    }

    public String getAcceptAdmin() {
        return this.acceptAdmin;
    }

    public void setAcceptAdmin(String acceptAdmin) {
        this.acceptAdmin = acceptAdmin;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOldId() {
        return this.oldId;
    }

    public void setOldId(Long oldId) {
        this.oldId = oldId;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public Long getBuyerId() {
        return this.buyerId;
    }

    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public Timestamp getPayLimitTime() {
        return this.payLimitTime;
    }

    public void setPayLimitTime(Timestamp payLimitTime) {
        this.payLimitTime = payLimitTime;
    }

    public Timestamp getAcceptTime() {
        return this.acceptTime;
    }

    public void setAcceptTime(Timestamp acceptTime) {
        this.acceptTime = acceptTime;
    }

    public Timestamp getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(Timestamp finishTime) {
        this.finishTime = finishTime;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getRefundStatus() {
        return this.refundStatus;
    }

    public void setRefundStatus(Integer refundStatus) {
        this.refundStatus = refundStatus;
    }

    public String getStatusDesc() {
        return this.statusDesc;
    }

    public void setStatusDesc(String statusDesc) {
        this.statusDesc = statusDesc;
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public void setStatusMsg(String statusMsg) {
        this.statusMsg = statusMsg;
    }

    public Integer getPayStatus() {
        return this.payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public Integer getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getOrderAmount() {
        return this.orderAmount;
    }

    public void setOrderAmount(Integer orderAmount) {
        this.orderAmount = orderAmount;
    }

    public Integer getFreeAmount() {
        return this.freeAmount;
    }

    public void setFreeAmount(Integer freeAmount) {
        this.freeAmount = freeAmount;
    }

    public Integer getVoucherOffsetAmount() {
        return this.voucherOffsetAmount;
    }

    public void setVoucherOffsetAmount(Integer voucherOffsetAmount) {
        this.voucherOffsetAmount = voucherOffsetAmount;
    }

    public Integer getPayAmount() {
        return this.payAmount;
    }

    public void setPayAmount(Integer payAmount) {
        this.payAmount = payAmount;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public OrderTicketPo getTicket() {
        return this.ticket;
    }

    public void setTicket(OrderTicketPo ticket) {
        this.ticket = ticket;
    }

    public OrderConsigneePo getConsignee() {
        return this.consignee;
    }

    public void setConsignee(OrderConsigneePo consignee) {
        this.consignee = consignee;
    }

    public List<OrderItemPo> getItems() {
        return this.items;
    }

    public void setItems(List<OrderItemPo> items) {
        this.items = items;
    }

    public List<OrderVoucherPo> getVouchers() {
        return this.vouchers;
    }

    public void setVouchers(List<OrderVoucherPo> vouchers) {
        this.vouchers = vouchers;
    }

    public List<OrderPaymentPo> getPayments() {
        return this.payments;
    }

    public void setPayments(List<OrderPaymentPo> payments) {
        this.payments = payments;
    }

    public Long getShopId() {
        return this.shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getRejectReason() {
        return this.rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public List<OrderLogisticsPo> getLogisticses() {
        return this.logisticses;
    }

    public void setLogisticses(List<OrderLogisticsPo> logisticses) {
        this.logisticses = logisticses;
    }

    public List<OrderRefundItemPo> getOrderRefundItems() {
        return this.orderRefundItems;
    }

    public void setOrderRefundItems(List<OrderRefundItemPo> orderRefundItems) {
        this.orderRefundItems = orderRefundItems;
    }

    public DepotPo getDeliveryDepot() {
        return this.deliveryDepot;
    }

    public void setDeliveryDepot(DepotPo deliveryDepot) {
        this.deliveryDepot = deliveryDepot;
    }

    public DepotPo getPriceDepot() {
        return this.priceDepot;
    }

    public void setPriceDepot(DepotPo priceDepot) {
        this.priceDepot = priceDepot;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getNuomiId() {
        return this.nuomiId;
    }

    public void setNuomiId(Long nuomiId) {
        this.nuomiId = nuomiId;
    }

    public Long getNuomiBuyerId() {
        return this.nuomiBuyerId;
    }

    public void setNuomiBuyerId(Long nuomiBuyerId) {
        this.nuomiBuyerId = nuomiBuyerId;
    }

    public String getChannelUserId() {
        return this.channelUserId;
    }

    public void setChannelUserId(String channelUserId) {
        this.channelUserId = channelUserId;
    }

    public Integer getNuomiStatus() {
        return this.nuomiStatus;
    }

    public void setNuomiStatus(Integer nuomiStatus) {
        this.nuomiStatus = nuomiStatus;
    }

    public List<OrderSalePromotionItemPo> getPromotionItems() {
        return this.promotionItems;
    }

    public void setPromotionItems(List<OrderSalePromotionItemPo> promotionItems) {
        this.promotionItems = promotionItems;
    }

    public OrderPaymentPo getFirstOrderPaymentPo() {
        return (OrderPaymentPo)CollectionUtils.getFirstOrNull(this.payments);
    }

    public OrderSource getSource() {
        return this.source;
    }

    public void setSource(OrderSource source) {
        this.source = source;
    }

    public boolean isPayable() {
        if (!(this.status.equals(1) || this.status.equals(100) || this.payStatus != 1 && this.payStatus != 50)) {
            long now = System.currentTimeMillis();
            return now < (this.payLimitTime == null ? DateUtils.getDateOfDaysBack((int)-1, (Date)this.createTime).getTime() : this.payLimitTime.getTime());
        }
        return false;
    }

    public boolean isCancelable() {
        return this.status > 1 && this.status < 50;
    }

    public boolean isManageCancelable() {
        return this.status >= 1 && this.status <= 100;
    }

    public boolean isAcceptable() {
        return this.status == 20 && this.payStatus == 20;
    }

    public boolean isRejectable() {
        return this.isAcceptable();
    }

    public boolean isRefundable() {
        return this.status == 50 || this.refundStatus != null || this.status == 100;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPayTimeout() {
        if (this.status != 10) return false;
        if (this.payStatus != 1) return false;
        if (System.currentTimeMillis() <= (this.payLimitTime == null ? (this.createTime == null ? 0L : this.createTime.getTime()) : this.payLimitTime.getTime())) return false;
        return true;
    }

    public boolean isConfirmable() {
        return this.status == 50 && (this.payStatus == 100 || this.payStatus == 20 || this.payStatus == 30);
    }

    public boolean isContact() {
        return this.status == 50 || this.status == 100 || this.payStatus == 100;
    }

    public boolean isBuyAgain() {
        return this.status == 100;
    }

    public String getStatusName() {
        if (this.status == 1) {
            return "\u5df2\u53d6\u6d88";
        }
        if (this.status == 10 && (this.payStatus == 1 || this.payStatus == 50)) {
            return "\u5f85\u652f\u4ed8";
        }
        if (this.status == 20) {
            return "\u5f85\u5ba1\u6838";
        }
        if (this.status == 5) {
            return "\u5ba1\u6838\u672a\u901a\u8fc7";
        }
        if (this.status == 50) {
            return "\u5f85\u6536\u8d27";
        }
        if (this.status == 100) {
            return "\u5df2\u5b8c\u6210";
        }
        return "unknown";
    }

    public int calcPayAmountWithoutVoucher() {
        return this.orderAmount - this.freeAmount;
    }

    public int calcPayAmount() {
        return Math.max(this.orderAmount - this.freeAmount - this.voucherOffsetAmount, 0);
    }

    public void incVersion() {
        ++this.version;
    }

    public String debugInfo() {
        return StringUtils.join((Object[])new Serializable[]{"orderId=", this.id, " status=", this.status, " payStatus=", this.payStatus});
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public int compareTo(OrderPo orderPo) {
        return this.getCreateTime().compareTo(orderPo.getCreateTime());
    }

    public boolean isCanApplyRefund() {
        return this.status == 100 && this.refundStatus != 5 && this.refundStatus != 10;
    }

    public boolean isCanSyncOms() {
        return this.status == 50;
    }

    public Integer getChannelId() {
        return this.channelId;
    }

    public void setChannelId(Integer channelId) {
        this.channelId = channelId;
    }
}

