/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.organization;

import com.depotnearby.common.po.CommonStatus;
import com.depotnearby.common.po.Persistent;
import com.depotnearby.common.po.admin.Admin;
import com.depotnearby.common.po.geo.CityPo;
import com.depotnearby.util.DateTool;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Table(name="org_company")
public class CompanyPo
implements Persistent,
Comparable<CompanyPo> {
    @Id
    private Long id;
    @ManyToOne(optional=true)
    @JoinColumn(name="parentId")
    private CompanyPo parent;
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    private List<CompanyPo> subCompanies;
    @Column(length=40)
    private String name;
    @Column(columnDefinition="MEDIUMTEXT")
    private String description;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="org_company_city", joinColumns={@JoinColumn(name="company_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="city_id", referencedColumnName="id")}, uniqueConstraints={@UniqueConstraint(columnNames={"company_id", "city_id"})})
    private List<CityPo> cities;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="org_company_admin", joinColumns={@JoinColumn(name="company_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="admin_id", referencedColumnName="username")}, uniqueConstraints={@UniqueConstraint(columnNames={"company_id", "admin_id"})})
    private List<Admin> admins;
    @Column(columnDefinition="TINYINT", nullable=false)
    @Convert(converter=CommonStatus.CommonStatusConverter.class)
    private CommonStatus status;
    private Timestamp createTime = DateTool.nowTimestamp();
    private Timestamp latestUpdateTime = DateTool.nowTimestamp();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CompanyPo getParent() {
        return this.parent;
    }

    public void setParent(CompanyPo parent) {
        this.parent = parent;
    }

    public List<CompanyPo> getSubCompanies() {
        return this.subCompanies;
    }

    public void setSubCompanies(List<CompanyPo> subCompanies) {
        this.subCompanies = subCompanies;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<CityPo> getCities() {
        return this.cities;
    }

    public void setCities(List<CityPo> cities) {
        this.cities = cities;
    }

    public List<Admin> getAdmins() {
        return this.admins;
    }

    public void setAdmins(List<Admin> admins) {
        this.admins = admins;
    }

    public CommonStatus getStatus() {
        return this.status;
    }

    public void setStatus(CommonStatus status) {
        this.status = status;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public Timestamp getLatestUpdateTime() {
        return this.latestUpdateTime;
    }

    public void setLatestUpdateTime(Timestamp latestUpdateTime) {
        this.latestUpdateTime = latestUpdateTime;
    }

    @Override
    public int compareTo(CompanyPo o) {
        return o == null || o.name == null ? 1 : (this.name == null ? -1 : this.name.compareTo(o.getName()));
    }
}

