/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.product;

import com.depotnearby.common.po.Persistent;
import com.depotnearby.common.po.admin.Admin;
import com.depotnearby.common.po.depot.DepotType;
import com.depotnearby.common.po.organization.CompanyPo;
import com.depotnearby.common.po.product.ProductLimitLevel;
import com.depotnearby.common.po.product.ProductLimitStatus;
import com.depotnearby.common.po.product.ProductPo;
import com.depotnearby.common.po.shop.ShopLevel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.codelogger.utils.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

@Entity
@Table(name="pro_product_limit_price")
public class ProductLimitPricePo
implements Persistent {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="productId")
    private ProductPo product;
    @Column(columnDefinition="TINYINT")
    @Convert(converter=ProductLimitLevel.Converter.class)
    private ProductLimitLevel productLimitLevel;
    @Column(length=50)
    private String depotTypeIds;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="companyId")
    private CompanyPo company;
    @Column(columnDefinition="TINYINT")
    @Convert(converter=ShopLevel.Converter.class)
    private ShopLevel shopLevel = ShopLevel.VIP_ALL;
    @Column
    private Integer limitPrice;
    @Column
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date startTime;
    @Column
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date endTime;
    @Column(columnDefinition="TINYINT")
    @Convert(converter=ProductLimitStatus.Converter.class)
    private ProductLimitStatus status = ProductLimitStatus.INIT;
    @Column
    private Date createTime;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="username")
    private Admin createAdmin;
    @Column
    private Date updateTime;
    @Column
    private String updateAdmin;

    public List<DepotType> getLimitDepotType() {
        String[] ids;
        ArrayList<DepotType> depotTypes = new ArrayList<DepotType>();
        if (StringUtils.isNotBlank((String)this.depotTypeIds) && (ids = this.depotTypeIds.split(",")).length > 0) {
            for (String id : ids) {
                if (!StringUtils.isNotBlank((String)id)) continue;
                depotTypes.add((DepotType)((Object)new DepotType.Converter().convertToEntityAttribute(Integer.parseInt(id))));
            }
        }
        return depotTypes;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ProductPo getProduct() {
        return this.product;
    }

    public void setProduct(ProductPo product) {
        this.product = product;
    }

    public ProductLimitLevel getProductLimitLevel() {
        return this.productLimitLevel;
    }

    public void setProductLimitLevel(ProductLimitLevel productLimitLevel) {
        this.productLimitLevel = productLimitLevel;
    }

    public CompanyPo getCompany() {
        return this.company;
    }

    public void setCompany(CompanyPo company) {
        this.company = company;
    }

    public ShopLevel getShopLevel() {
        return this.shopLevel;
    }

    public void setShopLevel(ShopLevel shopLevel) {
        this.shopLevel = shopLevel;
    }

    public Integer getLimitPrice() {
        return this.limitPrice;
    }

    public void setLimitPrice(Integer limitPrice) {
        this.limitPrice = limitPrice;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public ProductLimitStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProductLimitStatus status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Admin getCreateAdmin() {
        return this.createAdmin;
    }

    public void setCreateAdmin(Admin createAdmin) {
        this.createAdmin = createAdmin;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateAdmin() {
        return this.updateAdmin;
    }

    public void setUpdateAdmin(String updateAdmin) {
        this.updateAdmin = updateAdmin;
    }

    public String getDepotTypeIds() {
        return this.depotTypeIds;
    }

    public void setDepotTypeIds(String depotTypeIds) {
        this.depotTypeIds = depotTypeIds;
    }
}

